// Copyright (c) 2004 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: StlReader.h,v 1.1 2007/01/25 22:09:07 halexan Exp $

#ifndef _OcpIp_StlReader_h_
#define _OcpIp_StlReader_h_

#include "IStl.h"
#include "StlParser.h"
#include "LineBuffer.h"
#include <vector>

class IChipDMCore_1;
namespace ocpip_legacy {
namespace OcpIp {
class StlReader : public IStlReader, public Sonics::LineBuffer, public StlParser
{
  public:
    StlReader( const string& fileName, const OcpParams& params, bool coreSystem );
    static vector<IStlReader*> findStlPrograms( const IChipDMCore_1* pQMaster,
                                                const string& directory="" );

    // interface functions
    virtual void next( bool& eof );
    virtual void setErrStream( ostream& err=cerr );
    virtual void setDefaultThread( uint32_t );
    virtual uint32_t       getCommandDelay() const;
    virtual StlCommandType getCommandType()  const;
    virtual uint32_t       getLineNum()      const;
    virtual string         getFileName()     const;
        
    virtual StlWaitCommand          getWaitCommand()          const;
    virtual StlSignalCommand        getSignalCommand()        const;
    virtual StlResetCommand         getResetCommand()         const;
    virtual StlControlStatusCommand getControlStatusCommand() const;

  protected:
    virtual void reportError( const string& stlLine, parse_info<> info );
    virtual void reportError( const string& stlLine, const string& errors );
};

}
}

#endif /* _OcpIp_StlReader_h_ */
