// 
//  Copyright 2008 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: main.cc,v 1.4 2006/02/25 03:01:05 Anssi Exp $
//
//  Description : OCP API -  TL1 profile example
//
// ============================================================================

// Turn on user messages
#define DEBUG_G1

// Turn off OCP protocol checker, if installed
//#define NDEBUG

// Include SystemC
#include "systemc"

// Include OCP files
#include "ocpip.h"
// Include user-defined headers
#include "command_line.h"

// Include submodules
#include "master_w.h"
#include "master_r.h"
#include "slave.h"

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  map_string_type  ocpParamMap1, ocpParamMap2;
  std::string ocpParamFileName1, ocpParamFileName2;

  sc_core::sc_clock clk;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName1, ocpParamFileName2);

  // Read OCP parameters from file
  if ( ! ocpParamFileName1.empty() ) {
    readMapFromFile(ocpParamFileName1, ocpParamMap1);
  }
  if ( ! ocpParamFileName2.empty() ) {
    readMapFromFile(ocpParamFileName2, ocpParamMap2);
  }

  

  // Submodules
  Slave sl1("sl1");
  Master_w ms1("ms1");
  Master_r ms2("ms2");

  // Set OCP configuration
  ocpip::ocp_parameters params;
  params=create_ocp_configuration_from_map("sl1", ocpParamMap1);
  sl1.wP.set_ocp_config(params);
  params=create_ocp_configuration_from_map("ms1", ocpParamMap1);
  ms1.ipP.set_ocp_config(params);

  params=create_ocp_configuration_from_map("sl1", ocpParamMap2);
  sl1.rP.set_ocp_config(params);
  params=create_ocp_configuration_from_map("ms2", ocpParamMap2);
  ms2.ipP.set_ocp_config(params);
 
#ifdef USE_OCP_MONITOR
  ocpip::ocp_connection_monitor<32> ocp_monitor_t_piece1(ms1.ipP,sl1.wP);
  ocpip::ocp_tl1_monitor_adapter<32,32> mon_adapt1(ocp_monitor_t_piece1);  

  ocpip_legacy::OCP_TL1_Trace_Monitor_Clocked<ocpip::ocp_data_class_unsigned<32,32> > tracer1("Tracer1", "ocp0.ocp");
  tracer1.p_mon(mon_adapt1);
  tracer1.p_clk(clk);

  ocpip::ocp_connection_monitor<32> ocp_monitor_t_piece2(ms2.ipP,sl1.rP);
  ocpip::ocp_tl1_monitor_adapter<32,32> mon_adapt2(ocp_monitor_t_piece2);  

  ocpip_legacy::OCP_TL1_Trace_Monitor_Clocked<ocpip::ocp_data_class_unsigned<32,32> > tracer2("Tracer2", "ocp1.ocp");
  tracer2.p_mon(mon_adapt2);
  tracer2.p_clk(clk);
#else
  ms1.ipP(sl1.wP);
  ms2.ipP(sl1.rP);
#endif
  ms1.clk(clk);
  ms2.clk(clk);
  sl1.clk(clk);

  // Simulator
  sc_core::sc_start(120, sc_core::SC_NS);
  
  return(0);
}
