#ifndef _namedIndex_h
#define _namedIndex_h

#include <vector>
#include <string>
#include <assert.h>

#if __GNUC__ >= 3 && __GNUC_MINOR__ >= 2
using namespace std;
#endif

#if __GNUC__ >= 4
using namespace std;
#endif

//! \brief Associate C++ names with an arbitrary enumeration.

//! Typically used in contexts where a model of a structure with named
//! components needs fast access to the components (constant time and without a
//! string comparison)\n
//! The only reason this is templated is to create one static name sequence
template<typename T>
class NamedIndex {
  public:
    typedef T Index;
    NamedIndex();
    //! \brief Get the string name associated to an enumerated value
    const string& getName( int index ) const {
        assert( index < end() );
        return getNameSeq()[index];
    }

    typedef int Iterator;
    //! \brief Begin iterator to the enumerated sequence
    Iterator begin() const { return 0; }
    //! \brief End iterator to the enumerated sequence
    Iterator end()   const { return getNameSeq().size(); }

  protected:
    //! \brief Add a new name, order must follow the enumeration
    void add( const string& name, int index=-1 ) {
        if ( index >= 0 ) assert( index == end() );
        getNameSeq().push_back( name );
    }
  private:
    static vector<string>& getNameSeq();
};

#define DEFINE_NAMED_INDEX_SEQ(T)                      \
template<>                                             \
vector<string>&                                        \
NamedIndex<T>::getNameSeq() {                          \
  static vector<string>* pVec = new vector<string>();  \
  return *pVec;                                        \
}

template<typename T>
NamedIndex<T>::NamedIndex() 
{
}

class NoNameIndex : public NamedIndex<NoNameIndex> {
public:
    typedef int Index;
};

#endif /* _namedIndex_h */
