// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//
//  Description:  Point to point TL2 example using the OCP-specific TL2 API
//  $Id: simple_ocp_master_tl2.h,v 1.1.1.1 2004/09/24 09:26:20 sguntz Exp $
//
// ============================================================================

//#define DEBUG_C
//#define TRACE_C

#ifndef SIMPLE_MASTER_TL2_H
#define SIMPLE_MASTER_TL2_H

#include "systemc.h"
#include "ocp_globals.h"
#include "ocp_param.h"
#include "ocp_tl2_master_port.h" 

// ----------------------------------------------------------------------------
// SIMPLE MASTER MODULE:
//
//  * non-pipelined module: uses one thread for request and response
//  * uses an OCP-specific TL2 master port
//  * uses a'OCPRequestGrp' structure to pass all the request signals to the
//      channel, and a 'OCPResponseGrp' structure to store the response
//      signals
//  * uses a single thread: MThreadID = 1
//  * performs the following actions:
//      - sends a 10-length WRITE burst to the slave using
//        sendOCPRequestBlocking(). Only one chunk is used (i.e. transaction is
//        atomic).
//      - sends a 10-length READ burst to the slave using
//        sendOCPRequestBlocking(). Only one chunk is used (i.e. transaction is
//        atomic).
//      - waits and get the corresponding response using two successive
//        getOCPResponseBlocking() calls catching 5-length chunks. Note that
//        the SThreadID signal is internally tested to check that this response
//        is the right one. 
//      - performs a complete 20-length WRITE transaction using the serialized
//        method 'OCPWriteTransfer()'. This call includes the followig phases:
//        request send, request acknowledge.
//      - performs a complete 20-length READ transaction using the serialized
//        method 'OCPReadTransfer()'. This call includes the followig phases:
//        request send, request acknowledge, response get and response
//        acknowledge
// 
// ----------------------------------------------------------------------------


SC_MODULE(simple_ocp_master_tl2) {

    // OCP-specific TL2 specialized master port 
    OCP_TL2_MasterPort<int, int> MasterP;

    // this module has SC processes
    SC_HAS_PROCESS(simple_ocp_master_tl2);


	//void request_response_thread();
	void request_thread();
	void response_thread();

	simple_ocp_master_tl2(sc_module_name mod);

	// ----------------------------------------------------------------------------
    // Internal class members 
    // ----------------------------------------------------------------------------
    private:
    
    // Array storing data to be sent
    int wdata[100];

    // OCP Request/Response structures
    OCPRequestGrp<int, int> m_req;
    OCPResponseGrp<int> m_resp;

};

#endif
