///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2006 OCP-IP
// OCP-IP Confidential & Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//          Date: 02/22/2006
//
//  Description :  OCP Channel Transaction Recording Monitor
//	  This channel monitor is based on the transaction recording 
//	  API in the SystemC Verification (SCV) Library. It targets 
//	  performance analysis for architectural modeling.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _OCP_TL3_PERF_MONITOR_H
#define _OCP_TL3_PERF_MONITOR_H

#include <systemc.h>

#include "ocp_tl3_monitor_port.h"
#include "ocp_tl3_perf_monitor_scv.h"


template 
< typename REQ, 
  typename RESP
>
class OCP_TL3_Perf_Monitor :
  public sc_module
{
public:
  SC_HAS_PROCESS(OCP_TL3_Perf_Monitor);

  /** this port shall be bound to the monitor interface of the OCP channel */
  OCP_TL3_MonitorPort<REQ,RESP> p_mon;
  
  OCP_TL3_Perf_Monitor(sc_module_name name) :
    sc_module(name),
    p_mon("p_mon")
  {
    m_channel_monitor = new OCP_TL3_Perf_Monitor_SCV<REQ,RESP>(name);
  }
  
  virtual ~OCP_TL3_Perf_Monitor()
  {
    delete m_channel_monitor;
  }

  void end_of_elaboration()
  {
    p_mon->RegisterRequestStart(m_channel_monitor);
    p_mon->RegisterRequestEnd(m_channel_monitor);
    p_mon->RegisterResponseStart(m_channel_monitor);
    p_mon->RegisterResponseEnd(m_channel_monitor);
    
    m_channel_monitor->registerChannel(p_mon[0]);
  }

  void start_of_simulation()
  {
  }

protected:
  OCP_TL3_Monitor_ObserverIF<REQ,RESP>* m_channel_monitor;
};

#endif
