// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level 
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Joe Chou, Sonics Inc., joechou@sonicsinc.com 
//         Date : 02/15/2003
//
//  Description : Transaction Level direct interface declaration
//                The direct interface methods can be used to write/read
//                data in both directions (Master to Slave and Slave to Master)
//                Without using any resources or affecting the timing.
//                These methods are executed immediately. They are useful
//                e.g for debugging or to initialize some memory.
//                
// ============================================================================

// This file contains the definition of the classes:
// template <class TdataCl> class SdirectIF
// template <class TdataCl> class MdirectIF


#ifndef _TL_DIRECT_IF_H
#define _TL_DIRECT_IF_H

//--------------------------------------------------------
//
//  INTERFACE : Direct read/write interface
//--------------------------------------------------------

template <class TdataCl> class SdirectIF
  : virtual public sc_interface
{
public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // Direct access method Master to Slave direction.
  virtual bool MputDirect(int, bool, Td*, Ta, int) = 0;

};

template <class TdataCl> class MdirectIF
  : virtual public sc_interface
{
public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // Direct access method Slave to Master direction.
  virtual bool SputDirect(int, bool, Td*, Ta, int) = 0;

};

#endif // _TL_DIRECT_IF_H

