/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2003 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.4 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

// ============================================================================
//      Project : Generic SystemC TL Communication Methodology
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//         Date : 11/15/2002
//
//  Description : ATM cell class.
//                This class can be used in the TL3 example as template
//                argument for the data type.
//
//   This is an example of an ATM Cell structure at the
//   User Network Interface (UNI)
//
// ============================================================================

// This file contains the definition of the classes:
// class ATM_Cell

#ifndef _ATM_Cell
#define _ATM_Cell

class ATM_Cell
{
public:

  // Constructor
  ATM_Cell()
  {
    // initialize
    GFC  = 0;
    VPI  = 0;
    VCI  = 0;
    PTI  = 0;
    CLP  = 0;
    HEC  = 0;
    Info = 0;
  }

  // Destructor
  ~ATM_Cell()
  {
  }

// It is useful to overload the copy operator.
// Then direct access methods etc. don't need to be changed
ATM_Cell& operator = (const ATM_Cell B)
{
  GFC  = B.GFC;
  VPI  = B.VPI;
  VCI  = B.VCI;
  PTI  = B.PTI;
  CLP  = B.CLP;
  HEC  = B.HEC;
  Info = B.Info;
  return(*this);
}

// provide an TL3 to TL2 data converter
static void ATM_Cell2int (int *A, const ATM_Cell B)
{
  A[0] = B.GFC | (B.VPI << 4) | (B.VCI << 16);
  A[1] = B.PTI | (B.CLP << 3) | (B.HEC << 4) | (B.Info << 12);
  A[2] = B.Info >> 20;
}

// provide an TL2 to TL3 data converter
static void int2ATM_Cell (ATM_Cell A, int *B)
{
  A.GFC  = B[0];
  A.VPI  = B[0] >> 4;
  A.VCI  = B[0] >> 16;
  A.PTI  = B[1];
  A.CLP  = B[1] >> 3;
  A.HEC  = B[1] >> 4;
  A.Info = (B[1] >> 12) | (B[2] << 20);
}

// int, long etc would be faster however, we want to test a
// more complex structure
sc_uint<4>  GFC;
sc_uint<8>  VPI;
sc_uint<16> VCI;
sc_uint<3>  PTI;
sc_uint<1>  CLP;
sc_uint<8>  HEC;
sc_uint<48> Info;

};
#endif // ATM_Cell
