// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Joe Chou, Sonics Inc., joechou@sonicsinc.com
//         Date : 06/03/2003
//
// ============================================================================

#ifndef _ModelConfigCl_H
#define _ModelConfigCl_H

#include <iostream>
#include <fstream>
#include "ModelConfigGlobals.h"
#include "SCILexer.hpp"
#include "SCIParser.hpp"
#include <cassert>

// utility functions to be used by OCP channels and Cores
class ModelConfigCl {
public:
    // constructor
    ModelConfigCl(const char* file_name) {
        ifstream inpf;

        // open the input file
        inpf.open(file_name);
        assert(inpf.is_open());

        // parse the input file and build a configuratoin database
        //ANTLR_USING_NAMESPACE(std)
        try {
            SCILexer lexer(inpf);
            SCIParser parser(lexer);
            parser.program(m_Map,m_ConnectionList,m_InstanceList,
                           m_ClockList);
            std::cout << "done" << endl;
        } catch (exception& e) {
            std::cerr << "exception: " << e.what() << endl;
        }
    }

    // destructor
    ~ModelConfigCl() {
        ;
    }

    // get an OCP connection's configuratoin
    void getOCPConfiguration(string name, MAPType& map) {
        bool is_member = false;

        // see whether the connection exists
        SETType::iterator set_it;
        for (set_it = m_ConnectionList.begin();
             set_it != m_ConnectionList.end(); ++set_it) {
            if (*set_it == name) {
                is_member = true;
                break;
            }
        }

        // 
        if (!is_member) {
            cout << endl << "ERROR: no OCP named:" << name << endl;
        } else {
            // copy the connection's map to the provided argument
            MAPType::iterator map_it;
            unsigned int      len = name.length();

            for (map_it = m_Map.begin(); map_it != m_Map.end(); ++map_it) {
                string key(map_it->first,1,len);

                if (key == name) {
                    // copy this item
                    map.insert(MAPType::value_type(map_it->first,
                                                   map_it->second));
                }
            }
        }
    }

    // get an instance's configuratoin
    void getInstanceConfiguration(string name, MAPType& map) {
        bool is_member = false;

        // see whether the instance exists
        SETType::iterator set_it;
        for (set_it = m_InstanceList.begin();
             set_it != m_InstanceList.end(); ++set_it) {
            if (*set_it == name) {
                is_member = true;
                break;
            }
        }

        // 
        if (!is_member) {
            cout << endl << "ERROR: no instance named:" << name << endl;
        } else {
            // copy the instance's map to the provided argument
            MAPType::iterator map_it;
            unsigned int      len = name.length();

            for (map_it = m_Map.begin(); map_it != m_Map.end(); ++map_it) {
                string key(map_it->first,1,len);

                if (key == name) {
                    // copy this item
                    map.insert(MAPType::value_type(map_it->first,
                                                   map_it->second));
                }
            }
        }
    }

    // dump out the internal database
    void dumpDatabase(void) {
        // dump out the map
        cout << endl << "Map:" << endl;
        MAPType::iterator map_it;
        for (map_it = m_Map.begin(); map_it != m_Map.end(); ++map_it) {
            cout << "map[" << map_it->first << "] = " << map_it->second << endl;
        }

        // dump out the connection list
        cout << endl << "Connections:" << endl;
        SETType::iterator set_it;
        for (set_it = m_ConnectionList.begin();
             set_it != m_ConnectionList.end(); ++set_it) {
            cout << *set_it << endl;
        }

        // dump out the instance list
        cout << endl << "Instances:" << endl;
        for (set_it = m_InstanceList.begin();
             set_it != m_InstanceList.end(); ++set_it) {
            cout << *set_it << endl;
        }

        // dump out the clock list
        cout << endl << "Clocks:" << endl;
        for (set_it = m_ClockList.begin();
             set_it != m_ClockList.end(); ++set_it) {
            cout << *set_it << endl;
        }
    }

private:
    MAPType  m_Map;
    SETType  m_ConnectionList;
    SETType  m_InstanceList;
    SETType  m_ClockList;
};

#endif // _ModelConfigCl_H
