// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stphane Guntz, PROSILOG, guntz@prosilog.com
//         Date : 06/2003
//
//  Description : 
//  testbench for tl1 master adapter example
//
// ============================================================================


#include "systemc.h"
#include "ocp_tl1_master.h"
#include "ocp_tl2_slave.h"
#include "ocp_tl1_tl2_master_adapter.h"
#include "tl_channel.h"


int sc_main(int argc, char* argv[])
{

  bool SynchronChannel= true;
  
  sc_clock clk("clock", 1, SC_NS, 0.5, 0, SC_NS, true);

  //TL1 and TL2 channels instantiation 
  TL_Channel<TL1_TEMPL_DATA_CL > channel0("channel0", SynchronChannel);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > channel1("channel1",SynchronChannel,true);


  //TL1 master instantiation 
 OCP_TL1_Master<TL1_TEMPL_DATA_CL > master1("ms1", 1, 1, 20);
  //TL1 slave instantiation: pipelined, no response to a write request
  //no accept and response delays
  OCP_TL2_Slave<OCP_TL2_TEMPL_DATA_CL > slave1("sl1", 1, 0x0, 0x3FF, true, false, 0, 0, 0, 0);

  //adapter instantiation
  //maximum burst length=8, adapter depth= 12
  OCP_TL1_TL2_Master_Adapter<TL1_TEMPL_DATA_CL, OCP_TL2_TEMPL_DATA_CL > master_adapter("master_adapter", 8, 6);


  //binding
  master1.MasterP(channel0);
  master1.clk(clk);

  master_adapter.SlaveP(channel0);
  master_adapter.MasterP(channel1);
  master_adapter.clk(clk);

  slave1.SlaveP(channel1);


  sc_start(50, SC_NS);

  return 0;
}
