// 
// Copyright 2003 OCP-IP
// OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//         Date : 10/16/2003
//
//  Description:  Regresion test 4 for the OCP-specific TL2 API.
//                Just tests the 'ThreadBusy' methods and events.
// ============================================================================

//#define DEBUG_C
//#define TRACE_C

#include <string>

using namespace std;

#include <systemc.h>
#include "ocp_tl2_channel.h"  
#include "ocp_tl2_master_port.h"  
#include "ocp_tl2_slave_port.h"  

// ----------------------------------------------------------------------------
// MASTER MODULE:
// ----------------------------------------------------------------------------


SC_MODULE(master) {

    // OCP-specific TL2 specialized master port 
    OCP_TL2_MasterPort<unsigned int, unsigned int> ocp;

    // this module has SC processes
    SC_HAS_PROCESS(master);

    void request_thread () {

        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(0) == true);
        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(0) == false);
        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(1) == true);
        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(1) == false);
        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(2) == true);
        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(2) == false);
        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(3) == true);
        wait(ocp->SThreadBusyEvent());
        assert(ocp->getSThreadBusyBit(3) == false);

        cout << "OCP TL2 API Regression test 4 part 1 PASSED..." << endl;
        
    }
        
    void response_thread () {

        wait(20,SC_NS);

        ocp->putMThreadBusyBit(true, 0);
        wait(10,SC_NS);
        ocp->putMThreadBusyBit(false, 0);
        wait(10,SC_NS);
        ocp->putMThreadBusyBit(true, 1);
        wait(10,SC_NS);
        ocp->putMThreadBusyBit(false, 1);
        wait(10,SC_NS);
        ocp->putMThreadBusyBit(true, 2);
        wait(10,SC_NS);
        ocp->putMThreadBusyBit(false, 2);
        wait(10,SC_NS);
        ocp->putMThreadBusyBit(true, 3);
        wait(10,SC_NS);
        ocp->putMThreadBusyBit(false, 3);

    }

    // ----------------------------------------------------------------------------
    // Constuctor
    // ----------------------------------------------------------------------------
    master(sc_module_name mod):
        sc_module(mod),
    ocp("Master_Port")
    {
        SC_THREAD(request_thread);
        SC_THREAD(response_thread);
    }

};

// ----------------------------------------------------------------------------
// SIMPLE SLAVE MODULE:
// ----------------------------------------------------------------------------

SC_MODULE(slave) {

    // OCP-specific TL2 specialized master port 
    OCP_TL2_SlavePort<unsigned int,unsigned int> ocp;

    // this module has SC processes
    SC_HAS_PROCESS(slave);

    void response_thread () {

        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(0) == true);
        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(0) == false);
        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(1) == true);
        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(1) == false);
        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(2) == true);
        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(2) == false);
        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(3) == true);
        wait(ocp->MThreadBusyEvent());
        assert(ocp->getMThreadBusyBit(3) == false);

        cout << "OCP TL2 API Regression test 4 part 2 PASSED..." << endl;
        
    }
        
    void request_thread () {

        wait(10,SC_NS);

        ocp->putSThreadBusyBit(true, 0);
        wait(10,SC_NS);
        ocp->putSThreadBusyBit(false, 0);
        wait(10,SC_NS);
        ocp->putSThreadBusyBit(true, 1);
        wait(10,SC_NS);
        ocp->putSThreadBusyBit(false, 1);
        wait(10,SC_NS);
        ocp->putSThreadBusyBit(true, 2);
        wait(10,SC_NS);
        ocp->putSThreadBusyBit(false, 2);
        wait(10,SC_NS);
        ocp->putSThreadBusyBit(true, 3);
        wait(10,SC_NS);
        ocp->putSThreadBusyBit(false, 3);

    }

    // ----------------------------------------------------------------------------
    // constuctor
    // ----------------------------------------------------------------------------
    slave(sc_module_name mod):
        sc_module(mod),
    ocp("Slave_Port")
    {
        SC_THREAD(request_thread);
        SC_THREAD(response_thread);
    }
};

int sc_main(int argc, char* argv[])
{
    // Creates the OCP TL2 channel
    OCP_TL2_Channel<unsigned int, unsigned int>  ch0("ch0");

    // Enable 'sthreadbusy' and 'mthreadbusy' parameters 
    ch0.GetParamCl()->sthreadbusy=true;
    ch0.GetParamCl()->mthreadbusy=true;

    // Creates masters and slaves 
    slave sl1("sl1");
    master ms1("ms1");

    // Connect masters and slaves using channels
    ms1.ocp(ch0);
    sl1.ocp(ch0);

    // Starts simulation 
    sc_start(20000, SC_MS);

    return(0);
}



