// Copyright 2003 OCP-IP
// OCP-IP Confidential & Proprietary
//

//////////////////////////////////////////////////
//
//  Slave Interface for the OCP TL2 Channel
//
//////////////////////////////////////////////////

#ifndef _OCP_TL2_SLAVE_IF
#define _OCP_TL2_SLAVE_IF

#include "systemc.h"
#include "tl_slave_if.h"
#include "ocp_tl2_data_cl.h"

template <class Tdata, class Taddr>
class OCP_TL2_SlaveIF : virtual public TLslaveIF<OCP_TL2_DataCl<Tdata,Taddr> >
{
  public:

    //////////////////////////////////////////////////////////////
    // OCP TL2 Slave specific methods
    //////////////////////////////////////////////////////////////

    // Structure-passing Methods (Synchronization AND Group Access)
    //

    virtual bool getOCPRequest(OCPRequestGrp<Tdata,Taddr>& req, bool accept, unsigned int& ReqChunkLen, bool& last_chunk_of_a_burst) = 0;
    virtual bool getOCPRequestBlocking(OCPRequestGrp<Tdata,Taddr>& req, bool accept, unsigned int& ReqChunkLen, bool& last_chunk_of_a_burst) = 0;
    virtual bool sendOCPResponse(OCPResponseGrp<Tdata>& resp, unsigned int RespChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
    virtual bool startOCPResponse(OCPResponseGrp<Tdata>& resp, unsigned int RespChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
    virtual bool sendOCPResponseBlocking(OCPResponseGrp<Tdata>& resp, unsigned int RespChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
    virtual bool startOCPResponseBlocking(OCPResponseGrp<Tdata>& resp, unsigned int RespChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;

    // Synchronization methods
    virtual bool getMBusy(void) const = 0;
    virtual bool putSCmdAccept() = 0;
    virtual void putSThreadBusy(unsigned int nextMThreadBusy) = 0;
    virtual void putSThreadBusyBit(bool nextBitValue, unsigned int ThreadID = 0) = 0;
    virtual bool getMRespAccept(void) const = 0;
    virtual unsigned int getMThreadBusy(void) const = 0;
    virtual bool getMThreadBusyBit(unsigned int ThreadID = 0) const = 0;
    virtual void waitMRespAccept(void) = 0;

  // These methods can be used in place of Data Class methods (see below) to
  // set/get a complete group of signals (No synchronization is performed here)
    virtual  void GetRequestFields(OCPRequestGrp<Tdata,Taddr>& req, bool mdata_copy, unsigned int& ReqChunkLen, bool& last_chunk_of_a_burst) = 0;
    virtual void SetResponseFields(OCPResponseGrp<Tdata>& resp, unsigned int RespChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;

  //////////////////////////////////////////////////////////////
  // TL2 Data Class methods
  //////////////////////////////////////////////////////////////

    // Request Group Access methods
    virtual  Taddr SgetMAddr() = 0;
    virtual  unsigned int SgetMAddrSpace() = 0;
    virtual  unsigned int SgetMAtomicLength() = 0;
    virtual  OCPMBurstSeqType SgetMBurstSeq() = 0;
    virtual  unsigned int SgetMByteEn() = 0;
    virtual  OCPMCmdType SgetMCmd() = 0;
    virtual  unsigned int SgetMConnID() = 0;
    virtual  Tdata* SgetMData(unsigned int& w, bool& last_of_a_burst) = 0;
    virtual  Tdata* SgetMData(unsigned int& w) = 0;
    virtual  Tdata* SgetMData() = 0;
    virtual  unsigned int SgetMThreadID() = 0;
    virtual  unsigned int SgetMBurstLength() = 0;
    virtual  unsigned int SgetMBurstPrecise() = 0;
    virtual  unsigned int SgetMBurstSingleReq() = 0;
    virtual  unsigned int SgetMReqInfo() = 0;
    virtual  unsigned int SgetMReqLast() = 0;

    // Response Group Access methods
    virtual void SputSData(Tdata* d, unsigned int w = 1, bool last_of_a_burst = true) = 0;
    virtual void SputSDataInfo(unsigned int a) = 0;
    virtual void SputSResp(OCPSRespType a) = 0;
    virtual void SputSRespInfo(unsigned int a) = 0;
    virtual void SputSRespLast(bool a) = 0;
    virtual void SputSThreadID(unsigned int a) = 0;

    // DataHS Group Access methods
    virtual  unsigned int SgetMDataInfo() = 0;

    // ThreadBusy Group Access methods
    virtual unsigned int SgetMThreadBusy(void) const = 0;
    virtual void SputSThreadBusy(unsigned int sthreadbusy) = 0;

    // SideBand Group Access methods
    virtual bool SgetMError(void) const = 0;
    virtual unsigned int SgetMFlag(void) const = 0;
    virtual bool SgetMReset_n(void) const = 0;
    virtual void SputSReset_n(bool nextValue) = 0;
    virtual void SputSError(bool nextValue) = 0;
    virtual void SputSFlag(unsigned int nextValue) = 0;
    virtual void SputSInterrupt(bool nextValue) = 0;
    virtual void SysputControl(int nextValue) = 0;
    virtual bool SysgetControlBusy(void) const = 0;
    virtual void SysputControlWr(bool nextValue) = 0;
    virtual unsigned int SysgetStatus(void) const = 0;
    virtual bool SysgetStatusBusy(void) const = 0;
    virtual void SysputStatusRd(bool nextValue) = 0;
    virtual unsigned int CgetControl(void) const = 0;
    virtual void CputControlBusy(bool nextValue) = 0;
    virtual bool CgetControlWr(void) const = 0;
    virtual void CputStatus(int nextValue) = 0;
    virtual void CputStatusBusy(bool nextValue) = 0;
    virtual bool CgetStatusRd(void) const = 0;

    // TL2-specific burst chunks methods
    virtual void SputSRespChunkLen(unsigned int w) = 0;
    virtual void SputSRespChunkLast(bool w) = 0;
    virtual unsigned int SgetMReqChunkLen() const = 0;
    virtual bool SgetMReqChunkLast() const = 0;


    // Event accesses
    virtual const sc_event& RequestStartEvent(void) const = 0; 
    virtual const sc_event& RequestEndEvent(void) const = 0; 
    virtual const sc_event& ResponseStartEvent(void) const = 0; 
    virtual const sc_event& ResponseEndEvent(void) const = 0; 
    virtual const sc_event& MThreadBusyEvent(void) const = 0; 
    virtual const sc_event& SidebandMasterEvent(void) const = 0; 
    virtual const sc_event& SidebandResetEvent(void) const = 0; 
    virtual const sc_event& SidebandControlEvent(void) const = 0;
    virtual const sc_event& SidebandStatusEvent(void) const = 0;

};

#endif // _OCP_TL2_SLAVE_IF

