// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//         Date : 06/10/2004
//
//  Description : Transaction Level - Layer-0 to Layer-1 Slave Adapter (OCP 2.0)
//               (with Datahandshake support)
//
// ============================================================================

#ifndef _OCP_TL0_TL1_SLAVE_ADAPTER_HS
#define _OCP_TL0_TL1_SLAVE_ADAPTER_HS

#include "ocp_globals.h"
#include "ocp_tl1_slave_port.h"

template <class TdataCl> class OCP_TL0_TL1_Slave_Adapter_Hs
: public sc_module
, public SdirectIF<TdataCl>
{
    public:  

        typedef typename TdataCl::DataType Td;
        typedef typename TdataCl::AddrType Ta;

        // TL1 Slave Port
        OCP_TL1_SlavePort<TdataCl> SlaveP;

        // TL0 Basic OCP Master ports
        sc_in_clk             Clk;
        sc_out<sc_bv<3> > 	  MCmd;
        sc_out<Ta>          	MAddr;
        sc_in<bool>   	      SCmdAccept;

        sc_out<bool>   	      MDataValid;
        sc_out<Td>          	MData;
        sc_in<bool>   	      SDataAccept;

        sc_in<Td>           	SData;
        sc_in<sc_bv<2> >      SResp;
        sc_out<bool>  	      MRespAccept;

        SC_HAS_PROCESS(OCP_TL0_TL1_Slave_Adapter_Hs);

        // Default constructor: no need to specify explicit sampling times, use default ones
        OCP_TL0_TL1_Slave_Adapter_Hs(sc_module_name name_
                , int ID                   
                , bool Combinational
                , sc_time ClockCycle
                , bool Check_setup_time = true    
                );

        // Constructor with explicit sampling timings
        OCP_TL0_TL1_Slave_Adapter_Hs(sc_module_name name_
                , int ID                   
                , sc_time AcceptSampleDelay = sc_get_time_resolution() 
                , sc_time ResponseSampleDelay = sc_get_time_resolution() 
                , bool Check_setup_time = true    
                );

        // destructor
        ~OCP_TL0_TL1_Slave_Adapter_Hs();

        // methods
        virtual bool MputDirect(int, bool, Td*, Ta, int);

        void send_Response();
        void set_reset_MRespAccept_PE();
        void set_MRespAccept_Normal();
        void reset_MRespAccept_Normal();
        void reset_TL0_signals();
        void send_Request();
        void send_Data();
        void release_Request();
        void release_Data();
        void sample_events_trigger();
        void check_accept_setup_time();
        void check_response_setup_time();

    private :

        void end_of_elaboration();

        // Pointer to the communication class of the channel
        CommCl           *m_CommCl;

        // Pointer to the parameter class of the channel
        ParamCl<TdataCl>           *m_ParamCl;

        // Structures used to handle TL1 Requests/Responses
        OCPResponseGrp<Td>   TL1_response;
        OCPRequestGrp<Td,Ta>   TL1_request;
        OCPDataHSGrp<Td>   TL1_dataHS;

        // parameters
        sc_event e_response_sample_event;
        sc_event e_accept_sample_event;
        int m_ID;
        double m_DelayPct;
        sc_time m_accept_sample_delay;
        sc_time m_response_sample_delay;
        bool m_check_active;
        sc_time m_last_rising_edge;
        bool m_default_values;
        bool m_request_in_progress;
        bool m_datahs_in_progress;
        bool m_PE_mode;
      
        bool m_response_accepted;
        bool m_ready_for_response;
};


#endif // _OCP_TL0_TL1_SLAVE_ADAPTER_HS
