#ifndef _simControl_h
#define _simControl_h

#include <string>
#include <iostream>
#include <map>
#include <vector>
#include <systemc.h>
#include "DebugUtil.h"

using std::map;
using std::string;
using std::vector;

// Forward declarations
class IChipDMTop_1;
class IChipDMCore_1;
class IChipDMConnection_1;
class IChipDMInterface_1;

class PerfReportCl;
namespace Sonics {
class SimMonitor;
IChipDMTop_1* initChipDMTop( bool=false, const string& = "" );
void          getParameters( IChipDMConnection_1* pConn,
                             map<string,string>& paramMap );
void          getParameters( IChipDMCore_1* pCore,
                             map<string,string>& paramMap );
void          getParameters( IChipDMInterface_1* pInterface,
                             map<string,string>& paramMap );
void          setPerfReportInstance( PerfReportCl* p );
PerfReportCl* getPerfReportInstance();
void          setSimMonitorInstance( SimMonitor* p );
SimMonitor*   getSimMonitorInstance();
void          setDlTrace( bool on=true );
bool          getDlTrace();

void setInternalAdapterTraces( bool on=true );
bool getInternalAdapterTracesEnable();

class SimDriver {
public:
    SimDriver();
    virtual ~SimDriver();
protected:
    static int s_numDrivers;
};
}

#ifdef GZSTREAM_AVAILABLE
#define ADDGZIFENABLED( name ) string( #name ) + string( ".gz" )
#else
#define ADDGZIFENABLED( name ) string( #name )
#endif

// temporary hook
IChipDMTop_1* getChipDMTop();

#endif /* _simControl_h */
