// Copyright (c) 2004 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: OcpBundleDefs.cc,v 1.1 2007/01/25 22:09:07 halexan Exp $
#include "OcpBundleDefs.h"

using namespace OcpIp;

DEFINE_NAMED_INDEX_SEQ(ParamName)
DEFINE_NAMED_INDEX_SEQ(SignalName)

template<>
NamedIndex<ParamName>::NamedIndex() {
    if ( end() > begin() ) return;

#define OCPPARAMETER(name, def) add( #name, P_##name );
#include "ocp.parameters"
#undef OCPPARAMETER
}

template<>
NamedIndex<SignalName>::NamedIndex() {
    if ( end() > begin() ) return;

#define OCPSIGNAL(name, ARGS...)         add( #name, S_##name );
#define OCPSIGNAL_COMPLEX(name, ARGS...) add( #name, S_##name );
#include "ocp.signals"
#undef OCPSIGNAL
#undef OCPSIGNAL_COMPLEX
}
