// Copyright (c) 2004 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: LineBuffer.h,v 1.2 2007/02/05 14:22:46 guenzel Exp $
//
// Class to read a text file in lines, with chunk accesses
// without keeping file descriptor open

#ifndef _LineBuffer_h_
#define _LineBuffer_h_

#include <string>
#include <deque>
#include <fstream>

#if __GNUC__ >= 3 && __GNUC_MINOR__ >= 2
using namespace std;
#endif

#if __GNUC__ >= 4
using namespace std;
#endif

namespace Sonics {
class LineBuffer : public ifstream {

public:
    LineBuffer( const string& fileName, unsigned int bufferSize=4096 );
    string getCurrentLine() const;
    string getNextLine( int& len );
    void   setBufferSize( unsigned int numLines ) {
        m_numSlurpLines = numLines;
    }
    unsigned int getLineNum() const {
        return m_lineNum;
    }
    const string  m_fileName;

protected:
    unsigned int  m_lineNum;
    unsigned int  m_numSlurpLines;
    deque<string> m_stringBuffer;
    streampos     m_lastStop;
    bool slurp();
};
}

#endif /* _LineBuffer_h_ */
