// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP - TL2 example Master
//
// ============================================================================

#ifndef _OCP_TL2_MASTER_SYNC_H
#define _OCP_TL2_MASTER_SYNC_H

#define DEBUG_G1

#include <iostream>
#include "stdlib.h"

// User defined types
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl2_master_port.h"
#include "ocp_tl_param_cl.h"

template <typename TdataCl>
class Master : public sc_module
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // channel port
  OCP_TL2_MasterPort<Td, Ta> ipP;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_module_name name_);

  // destructor
  ~Master();

  // threads
  void proc_req();
  void proc_resp();

  bool tmp;
  int cnt;

  // Request group
  OCPRequestGrp<Td,Ta> req;
  // Response group
  OCPResponseGrp<Td> resp;

};


#endif // _OCP_TL2_MASTER_SYNC_H
