// 
//  (c) Copyright OCP-IP 2003, 2004, 2005
//  OCP-IP Confidential and Proprietary
//
// channel_types.h
// 
// Type definitions for the templated OCP channel.
// Used as an include file so that all modules in the
// example use the same channel type.
//

#ifndef _CHANNEL_TYPES_H
#define _CHANNEL_TYPES_H

//
#include <stdio.h>
#include <stdlib.h>

//
#include "systemc.h"
#include "ocp_tl1_data_cl.h"

// Standard Sizes
typedef unsigned char      OCPCHANNELBit8;
typedef unsigned short     OCPCHANNELBit16;
typedef unsigned int       OCPCHANNELBit32;
typedef uint64 OCPCHANNELBit64;
typedef sc_biguint<128>    OCPCHANNELBit128;

// 32-bit data word, 32-bit address
typedef OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> OCP_TL1_SIGNAL_CL;

#endif // _CHANNEL_TYPES_H
