// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: ocp_tl1_master_sync.h,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : Transaction Level - Layer-1 example Master
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_SYNC_H
#define _OCP_TL1_MASTER_SYNC_H

#include "ocp_tl1_globals.h"
#include "tl_master_if.h"

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

template <class TdataCl> class OCP_TL1_Master_Sync
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<TLmasterIF<TdataCl>, 1> MasterP;
  sc_in_clk  clk;

  SC_HAS_PROCESS(OCP_TL1_Master_Sync);

  // constructor
  OCP_TL1_Master_Sync(sc_module_name name_
             , int ID
             , int Priority
             , double DelayPct
            );

  // destructor
  ~OCP_TL1_Master_Sync();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void MasterRequest();
  void MasterResponse();


private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;

  // parameters
  int m_ID;
  int m_Priority;
  double m_DelayPct;
};


#endif // _OCP_TL1_MASTER_SYNC_H
