// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//
//  Description : Transaction Level - Layer-0 to Layer-1 Slave Adapter (OCP 2.0)
//               (with Datahandshake support)
//  $Id: ocp_tl0_tl1_slave_adapter.h,v 1.2 2005/11/18 15:39:13 halexan Exp $ 
//
// ============================================================================

#ifndef _OCP_TL0_TL1_SLAVE_ADAPTER_H
#define _OCP_TL0_TL1_SLAVE_ADAPTER_H

#include "ocp_globals.h"
#include "ocp_tl1_slave_port.h"
#include "ocp_tl0_port.h"
#include <vector>

template <typename TdataCl>
class OCP_TL0_TL1_Slave_Adapter : public sc_module
{
public:  
    
    typedef typename TdataCl::DataType Td;
    typedef typename TdataCl::AddrType Ta;

    // TL1 Slave Port
    OCP_TL1_SlavePort<TdataCl> SlaveP;

    // TL0 Basic OCP Master ports
    sc_in_clk                  Clk;
    OCP_TL0_MasterPorts&       m_tl0Ports;
     
    SC_HAS_PROCESS(OCP_TL0_TL1_Slave_Adapter);

public:
    // Constructor: specify tl0 interface class pointer
    OCP_TL0_TL1_Slave_Adapter(sc_module_name name_,
                              const OCP_TL0_PortFactory<OCP_TL0_MasterPorts>&,
                              bool checkSetupTime = true,
                              bool combinational  = true);

    // destructor
    ~OCP_TL0_TL1_Slave_Adapter();

    // methods
    virtual bool MputDirect(int, bool, Td*, Ta, int);

    void send_Response();
    void set_reset_MRespAccept_PE();
    void set_MRespAccept_Normal();
    void reset_MRespAccept_Normal();
    void reset_TL0_signals();
    void send_Reset();
    void send_Request();
    void send_Data();
    void release_Request();
    void release_Data();
    void set_TL1_ThreadBusy();
    void sample_events_trigger();
    // 
    void setClockPeriod ( const sc_time& );
    void setSampleDelays( const sc_time&, const sc_time& );
    void check_accept_setup_time();
    void check_response_setup_time();

private:
    void common_Setup();
    void end_of_elaboration();

    // Pointer to the communication class of the channel
    CommCl           *m_CommCl;

    // Pointer to the parameter class of the channel
    ParamCl<TdataCl>           *m_ParamCl;

    // Structures used to handle TL1 Requests/Responses
    OCPResponseGrp<Td>   TL1_response;
    OCPRequestGrp<Td,Ta>   TL1_request;
    OCPDataHSGrp<Td>   TL1_dataHS;

    // parameters
    sc_event e_response_sample_event;
    sc_event e_accept_sample_event;
    sc_event e_threadbusy_sample_event;
    double m_DelayPct;
    sc_time m_accept_sample_delay;
    sc_time m_response_sample_delay;
    sc_time m_threadbusy_sample_delay;
    bool m_check_active;
    sc_time m_last_rising_edge;
    bool m_default_values;
    bool m_request_in_progress;
    bool m_datahs_in_progress;
    bool m_PE_mode;
      
    bool m_response_accepted;
    bool m_ready_for_response;

    vector<unsigned int> m_burstXferCount;
};

#endif // _OCP_TL0_TL1_SLAVE_ADAPTER_H
