///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian
//
//          $Id:
//
//  Description :
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


template<typename T>
OCPIP_VERSION::ocp_txn_format::Displayable<T>&
OCPIP_VERSION::ocp_txn_format::Displayable<T>::operator=( T data )
{
    this->m_data = data;
    return *this;
}

template<typename T>
std::ostream&
OCPIP_VERSION::ocp_txn_format::Displayable<T>::streamIt( std::ostream& os ) const
{
    return( os << m_data );
}

template <typename objT>
OCPIP_VERSION::ocp_txn_format::DisplayEntryBase<objT>::DisplayEntryBase(
    const char* name, const char* reference, const char* legend ) :
    m_name( name ), m_reference( reference ), m_legend( legend )
{
    m_format.m_mode = FORMAT_STR;
}

template <typename objT>
void
OCPIP_VERSION::ocp_txn_format::DisplayEntryBase<objT>::setFormat( int mode, int width ) {
    m_format.m_mode = mode;
    m_format.m_width = width;
    if ( strlen( m_name ) > m_format.m_width )
	m_format.m_width = strlen( m_name );
}

template <typename objT, typename ownerT, typename dataT>
OCPIP_VERSION::ocp_txn_format::DisplayEntry<objT, ownerT, dataT>::DisplayEntry(
    const ownerT* pOwner, const char* name, const char* reference,
    OCPIP_VERSION::ocp_txn_format::DisplayEntry<objT, ownerT, dataT>::AccessFunc f,
    const char* legend ) :
    OCPIP_VERSION::ocp_txn_format::DisplayEntryBase<objT>( name, reference, legend ),
    m_pOwner( pOwner ),
    m_func( f )
{}

namespace OCPIP_VERSION {
template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
class ocp_tl2_txn_monitor_trans_access
{
  public:
    typedef typename ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::Transfer Transfer;
    typedef typename ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH>::DataType data_type;
    typedef typename ocp_data_class_unsigned<BUSWIDTH,ADDRWIDTH>::AddrType addr_type;

    inline double      _StartTime( const Transfer& t ) const
        { return t.m_startTime.to_default_time_units(); }
    inline unsigned long long _StartCycle( const Transfer& t ) const
        { return static_cast<unsigned long long>( t.m_startTime / m_period ); }
    inline uint32_t _MThreadID( const Transfer& t ) const
        { return t.m_p_invariant->threadid; }
    inline uint32_t _MTagID( const Transfer& t ) const
        { return t.m_p_invariant->tagid; }
    inline uint32_t _MConnID( const Transfer& t ) const
	{ return t.m_p_invariant->connid; }
    inline const char* _MCmd( const Transfer& t ) const
        { return ocpip_legacy::OcpIp::Literals::MCmd( t.m_p_invariant->cmd ); }
    inline const char* _MBurst( const Transfer& t ) const
        { return t.m_burstRepr; }
    inline const char* _MBurstSeq( const Transfer& t ) const
        { return ocpip_legacy::OcpIp::Literals::MBurstSeq( t.m_p_invariant->get_sequence() ); }
    inline char _LeftParen( const Transfer& t ) const
        { return ( ( true ) && t.m_burstCount > 1 ) ? '(' : ' '; }
    inline char _RightParen( const Transfer& t ) const
        { return ( ( true ) && t.m_burstCount > 1 ) ? ')' : ' '; }
    inline uint32_t _MAddrSpace( const Transfer& t ) const
        { return t.m_p_invariant->addr_space; }
    inline addr_type _MAddr( const Transfer& t ) const
        { return t.m_addr; }
    inline uint32_t _MByteEn( const Transfer& t ) const
        { return t.m_byteen; }
    inline unsigned long long _MReqInfo( const Transfer& t ) const
        { return 0xdead; }
    inline uint32_t _RqDL( const Transfer& t ) const
        { return t.m_RqDL; }
    inline uint32_t _RqAL( const Transfer& t ) const
        { return t.m_RqAL; }
    inline uint32_t _DAL( const Transfer& t ) const
        { return 0xdead; }
    inline data_type _Data( const Transfer& t ) const {
        return t.m_data;
    }   
    inline const char* _SResp( const Transfer& t ) const
        { return ( t.m_needsResponse ?
		   ocpip_legacy::OcpIp::Literals::SResp( t.m_resp ) : "." ); }
    inline unsigned long long _SRespInfo( const Transfer& t ) const
        { return 0xdead; }
    inline const char* _RqRpL( const Transfer& t ) const
        { return t.m_needsResponse ? t.m_respLatRepr : "."; }
    inline const char* _RpAL( const Transfer& t ) const
        { return t.m_needsResponse ? t.m_respAccRepr : "."; }

    sc_core::sc_time m_period;
};
}

template <typename objT, typename ownerT, typename dataT>
const OCPIP_VERSION::ocp_txn_format::DisplayableBase&
OCPIP_VERSION::ocp_txn_format::DisplayEntry<objT, ownerT, dataT>::display( const objT& o ) const
{        
    m_display = ( m_pOwner->*m_func )( o );
    return m_display;
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::init_display_fields()
{
    using namespace ocp_txn_format;
    typedef ocp_tl2_txn_monitor_trans_access<BUSWIDTH,ADDRWIDTH> t_access;
// This macro allows to condense this verbose text quite a bit
#define ADDENTRY( type, access, name, reference, format, width, legend )  \
    { pEntry = new DisplayEntry<Transfer, t_access, type>(                \
	  m_p_trans_access, name, reference,                              \
          &ocp_tl2_txn_monitor_trans_access<BUSWIDTH,ADDRWIDTH>::access,  \
	  legend );                                                       \
	pEntry->setFormat( format, width );                               \
	m_entries.push_back( pEntry );                                    \
    }            
    DisplayEntryBase<Transfer>* pEntry;
    ADDENTRY( double, _StartTime, "SimTime", "Time", FORMAT_DEC, 9,
	      "Simulation Time" );
    ADDENTRY( unsigned long long, _StartCycle, "Cycle", "Cycle", FORMAT_DEC, 7,
	      "Cycle Valid Time" );
    if ( m_ocp_params.burstsinglereq)
	ADDENTRY( char, _LeftParen, "", "", FORMAT_STR, 1, "");
    if ( m_ocp_params.threads > 1)
	ADDENTRY( uint32_t, _MThreadID, "T", "ThreadID", FORMAT_DEC,
		  int( ( ( m_ocp_params.threads - 1 ) / 10 ) + 1 ),
		  "Master and Slave Thread ID" );
    if ( m_ocp_params.tags > 1)
	ADDENTRY( uint32_t, _MTagID, "Tg", "TagID", FORMAT_DEC,
		  int( ( ( m_ocp_params.tags - 1 ) / 10 ) + 1 ),
		  "Master and Slave Tag ID" );
    if ( m_ocp_params.connid )
	ADDENTRY( uint32_t, _MConnID, "C", "MConnID", FORMAT_DEC,
		  int( ( ( m_ocp_params.connid_wdth - 1 ) / 4) + 1 ),
		  "Connection Identifier" );
    ADDENTRY( const char*, _MCmd, "Cmd", "MCmd", FORMAT_STR, 4,
	      "Master Command" );
    if ( m_ocp_params.burstseq )
	ADDENTRY( const char*, _MBurstSeq, "BuS", "MBurstSeq", FORMAT_STR, 4,
		  "Burst Sequence Type" );
    if ( m_ocp_params.blockheight ) {
	ADDENTRY( const char*, _MBurst, "Burst     ",
		  "transfer count/MBurstLengthxMBlockHeight/MBlockStride",
		  FORMAT_STR, 10, "running transfer count/burst length" );    
    } else if ( m_ocp_params.burstlength ) {
	ADDENTRY( const char*, _MBurst, "Burst", "transfer count/MBurstLength",
		  FORMAT_STR, 4, "running burst transfer count/burst length" );
    }
    if ( m_ocp_params.addrspace )
	ADDENTRY( uint32_t, _MAddrSpace, "AS", "MAddrSpace",
		  FORMAT_DEC, int( ( ( m_ocp_params.addrspace_wdth - 1 ) / 4 ) + 1 ),
		  "Master Address Space" );
    if ( m_ocp_params.addr )
	ADDENTRY( addr_type, _MAddr, "Addr", "MAddr",
		  FORMAT_HEX, int( ( ( m_ocp_params.addr_wdth - 1 ) / 4 ) + 1 ),
		  "Master Address" );
    if ( m_ocp_params.burstsinglereq)
	ADDENTRY( char, _RightParen, "", "", FORMAT_STR, 1, "" );
    if ( m_ocp_params.byteen || m_ocp_params.mdatabyteen )
	ADDENTRY( uint32_t, _MByteEn, "BE", "MByteEn",
		  FORMAT_HEX, int( ( ( m_ocp_params.data_wdth - 1 ) / 32 ) + 1 ),
		  "Byte Enables" );
    if ( m_ocp_params.reqinfo )
	ADDENTRY( unsigned long long, _MReqInfo, "Ri", "MReqInfo",
		  FORMAT_HEX, int( ( ( m_ocp_params.reqinfo_wdth - 1 ) / 4 ) + 1 ),
		  "Request Info" );
    if ( m_ocp_params.datahandshake )
	ADDENTRY( uint32_t, _RqDL, "RqDL", "RqDL", FORMAT_DEC, 4,
		  "Request Data Latency" );
    ADDENTRY( uint32_t, _RqAL, "RqAL", "RqAL", FORMAT_DEC, 4,
	      "Request Accept Latency" );
    if ( m_ocp_params.datahandshake )
	ADDENTRY( uint32_t, _DAL, "DAL", "DAL", FORMAT_DEC, 3,
		  "Data Accept Latency" );
    if ( m_ocp_params.mdata || m_ocp_params.sdata )
	ADDENTRY( data_type, _Data, "Data", "Data",
		  FORMAT_HEX, int( ( ( m_ocp_params.data_wdth - 1 ) / 4 ) + 1 ),
		  "MData (if write) or SData (if read)" );
    if ( m_ocp_params.resp )
	ADDENTRY( const char*, _SResp, "Resp", "SResp", FORMAT_STR, 4,
		  "Slave Response" );
    if ( m_ocp_params.respinfo )
	ADDENTRY( unsigned long long, _SRespInfo, "RI", "SRespInfo",
		  FORMAT_HEX, int( ( ( m_ocp_params.respinfo_wdth - 1 ) / 4 ) + 1 ),
		  "Response Info" );
    if ( m_ocp_params.resp ) {
	ADDENTRY( const char*, _RqRpL, "RqRpL", "RqRpL", FORMAT_DEC, 5,
		  "Request Response Latency" );
	ADDENTRY( const char*, _RpAL, "RpAL", "RpAL", FORMAT_DEC, 4,
		  "Response Accept Latency" );
    }
#undef ADDENTRY
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::t_log_header()
{
    using namespace ocp_txn_format;
    m_os << std::resetiosflags( std::ios::left ) << std::setiosflags( std::ios::right )
	 << "##\n"
	 << "# Legend for \"transfer\" write style (sorted by request cycle)\n" 
	 << "##\n";

    typename std::vector<DisplayEntryBase<Transfer>*>::iterator it;
    for( it = m_entries.begin(); it != m_entries.end(); ++it ) {
	const DisplayEntryBase<Transfer>& entry = **it;
	if ( strlen( entry.m_name ) == 0 )
	    continue;
	m_os << "# " << std::resetiosflags( std::ios::right ) << std::setiosflags( std::ios::left )
	     << std::setfill( ' ' ) << std::setw( 9 ) << entry.m_name
	     << std::setw( 1 )  <<  ":"
	     << std::resetiosflags( std::ios::left ) << std::setiosflags( std::ios::right )
	     << std::setw( 39 ) << entry.m_legend
	     << std::setw( 1 )  <<  " : "
	     << std::resetiosflags( std::ios::right ) << std::setiosflags( std::ios::left )
	     << std::setw( 28 ) << entry.m_reference << std::setw( 1 ) << '\n';
    }
    m_os << '\n';
    for( it = m_entries.begin(); it != m_entries.end(); ++it ) {
	const DisplayEntryBase<Transfer>& entry = **it;
	m_os << entry.format() << std::setfill( ' ' ) << entry.m_name << " ";
    }
    m_os << '\n';
    for( it = m_entries.begin(); it != m_entries.end(); ++it ) {
	const DisplayEntryBase<Transfer>& entry = **it;
	m_os << entry.format() << std::setfill( '-' ) << "" << std::setw( 1 ) << " ";
    }
    m_os << '\n';
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void
OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::get_thread_and_tag(
    tlm::tlm_generic_payload& txn, uint32_t& thread, uint32_t& tag)
{
    thread = tag = 0;
    thread_id* th_id; 
    if ( m_ext_support.template get_extension(th_id, txn) )
	thread = th_id->value;
    tag_id* tg_id; 
    if ( m_ext_support.template get_extension(tg_id, txn) )
	 tag = tg_id->value;
}

// Called with BEGIN_REQ
template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::t_log_new_req(
    tlm::tlm_generic_payload& txn )
{
    // extract the invariant and attach to txn + track burst position
    txn_invariant* p_inv;
    txn_position * p_pos;
    uint32_t thread, tag;
    get_thread_and_tag( txn, thread, tag );
    assert( thread < m_burst_tracker.size() );
    assert( tag    < m_burst_tracker[thread].size() );
    ocp_txn_track& track = m_burst_tracker[thread][tag];
    bool new_txn = false;
    if ( !track.has_pending_request() ) {
	// this is a new transaction
	new_txn = true;
	p_inv = m_invariantExtPool.create();
	*p_inv = txn_invariant::init_from( txn, m_ocp_params, m_ext_support );
	acc(txn).set_extension( p_inv );
	p_pos = m_positionExtPool.create();
	acc(txn).set_extension( p_pos );
	p_pos->req_position .count = 0;
	p_pos->dh_position  .count = 0;
	p_pos->resp_position.count = 0;
    }
    acc(txn).get_extension(p_inv);
    assert(p_inv);
    acc(txn).get_extension(p_pos);
    assert(p_pos);

    uint32_t starting_count = p_pos->req_position.count + 1;
    p_pos->req_position = track.track_phase( txn, tlm::BEGIN_REQ );

    word_count* word_count_info = NULL;
    bool has_word_count= m_ext_support.get_extension(word_count_info, txn);
    uint32_t req_word_count = has_word_count ?
	word_count_info->value.request_wc : p_inv->burst_length;

    sc_core::sc_time now = sc_core::sc_time_stamp();
    int interval = m_master_timing.RqSndI;
    sc_core::sc_time reqInterval = interval * m_period;

    // Expand TL2 request into individual transfers
    std::vector<Transfer> transfers( req_word_count );
    for ( uint32_t i=0; i < req_word_count; ++i ) {
	Transfer& transfer        = transfers[i];
	transfer.m_txn            = &txn;
	transfer.m_p_invariant    = p_inv;
 	transfer.m_RqDL           = 0; // until data phase
 	bool burstLengthSure = ( p_inv->precise || ( i == req_word_count - 1 ) );
 	if ( !burstLengthSure )
	    transfer.m_burst_length = 0xbad1dea; // not displayed
	else if ( !p_inv->precise )
	    transfer.m_burst_length = 1;

	// deadbeef will stay for reads that don't complete response
 	transfer.m_data   = 0xdeadbeef;
 	transfer.m_byteen = 0xffffffff;
	// need to de_serialize from transaction
	if ( txn.is_write() ) {
	    transfer.m_data = *((data_type*)( txn.get_data_ptr() + i ));
	}
	if ( txn.get_byte_enable_ptr() != NULL ) {
	    transfer.m_byteen = *((unsigned int*)( txn.get_byte_enable_ptr() + i ));
	} else {
	    transfer.m_byteen = 0xffffffff;
	    ocpip_legacy::OcpIp::trimWidth( transfer.m_byteen, int( m_ocp_params.data_wdth / 8 ) );
	}

// 	if ( !isRead && request.MDataPtr != NULL )
// 	    transfer.m_data = request.MDataPtr[i];
// 	if ( request.MByteEnPtr != NULL )
// 	    transfer.m_byteen = request.MByteEnPtr[i];
// 	OcpIp::trimWidth( transfer.m_byteen, int( m_ocp.data_wdth / 8 ) );
 	transfer.m_needsData = txn.is_write() && m_ocp_params.datahandshake;
 	transfer.m_needsResponse = txn.is_read() || m_ocp_params.writeresp_enable;
	if ( p_inv->srmd && txn.is_write() && ( !new_txn || i>0 ) ) {
	    // no response for continuing srmd write requests
	    transfer.m_needsResponse  = false;
	}
	    
	if ( p_inv->srmd ) {
	    transfer.m_startTime = p_inv->start_time;
	    // TODO: m_RqDL when logging data phase
// 	    if ( !txn.is_read() ) {
// 		transfer.m_RqDL = (int) (now.to_default_time_units() -
// 					 transfer.m_startTime.to_default_time_units());
// 		transfer.m_RqDL += i * interval;
// 	    }
	} else {
	    transfer.m_startTime      = now + ( i * reqInterval );
	}
	// Build burst string (count/length)
	transfer.m_burstCount = starting_count + i;
	unsigned int height = 1, stride = 0;
	if ( p_inv->get_sequence() == BLCK ) {
	    assert( p_inv->burst_seq_ext_valid );			
	    height = p_inv->burst_seq_ext.block_height;
	    stride = p_inv->burst_seq_ext.block_stride;
	}
	if ( !burstLengthSure )
	    sprintf( transfer.m_burstRepr, "%x/.", transfer.m_burstCount );
	else if ( p_inv->get_sequence() == BLCK ) {
	    sprintf( transfer.m_burstRepr, "%x/%xx%x/%x", transfer.m_burstCount,
		     p_inv->burst_length, height, stride );
	} else {
	    sprintf( transfer.m_burstRepr, "%x/%x", transfer.m_burstCount,
		     p_inv->burst_length );
	}

	// Compute address according to burst sequence
	if ( transfer.m_burstCount == 1 ) {
	    // txn address may not be ocp word aligned
	    addr_type addr_offset = calculate_ocp_address_offset(txn, m_byte_width );
	    m_addr_sequence[thread].init(
		txn.get_address() - addr_offset, p_inv->get_sequence(),
		p_inv->burst_length, p_inv->precise, height, stride );
	}
	burst_seqs seq=p_inv->get_sequence();
	if ( seq==UNKN || seq==DFLT1 || seq==DFLT2 ) {
	    assert(p_inv->burst_seq_ext_valid);
	    assert(seq!=UNKN || p_inv->burst_seq_ext.unkn_dflt_addresses_valid);
	    transfer.m_addr=p_inv->burst_seq_ext.unkn_dflt_addresses_valid ?
		p_inv->get_unkn_address(transfer.m_burstCount) 
		: txn.get_address(); //if we do not have a vector the address from the txn is the best guess...
	} else {
	    transfer.m_addr = m_addr_sequence[thread].next();
	}

	transfer.m_complete = !transfer.m_needsResponse && !transfer.m_needsData;

	// Queue it by time, and if incomplete in correct pending transfer queue
	m_timed_transfers.push_back( transfer );
	if ( transfer.m_needsData ) {
	    m_transfers_pending_data[thread][tag].push_back(
		&( m_timed_transfers.back() ) );
	}
	if ( transfer.m_needsResponse ) {
	    m_transfers_pending_resp[thread][tag].push_back(
		&( m_timed_transfers.back() ) );
	}	    
    }
    flush_queue();
}

// Called with BEGIN_DATA
template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::t_log_new_data(
    tlm::tlm_generic_payload& txn ) {

    txn_invariant* p_inv;
    acc(txn).get_extension(p_inv);
    assert(p_inv);
    txn_position* p_pos;
    acc(txn).get_extension(p_pos);
    assert(p_pos);

    ocp_txn_track& track = m_burst_tracker[p_inv->threadid][p_inv->tagid];
    p_pos->dh_position = track.track_phase( txn, BEGIN_DATA );

    word_count* word_count_info = NULL;
    bool has_word_count= m_ext_support.get_extension(word_count_info, txn);
    uint32_t data_word_count = has_word_count ?
	word_count_info->value.data_wc : p_inv->burst_length;

    sc_core::sc_time now = sc_core::sc_time_stamp();
    int interval = m_master_timing.DSndI;

    // Expand TL2 response to fill pending transfers
    for ( uint32_t i=0; i < data_word_count; ++i ) {
	assert( !m_transfers_pending_data[p_inv->threadid][p_inv->tagid].empty() );
	Transfer& transfer = *( m_transfers_pending_data
				[p_inv->threadid][p_inv->tagid].front() );
	assert( transfer.m_needsData && !transfer.m_complete );
	assert( txn.get_data_ptr() != NULL );
	// need to de_serialize from transaction
	transfer.m_data = *((data_type*)( txn.get_data_ptr() + i ));
	if ( txn.get_byte_enable_ptr() != NULL ) {
	    transfer.m_byteen = *((unsigned int*)( txn.get_byte_enable_ptr() + i ));
	} else {
	    transfer.m_byteen = 0xffffffff;
	    ocpip_legacy::OcpIp::trimWidth( transfer.m_byteen, int( m_ocp_params.data_wdth / 8 ) );
	}
	transfer.m_complete = !transfer.m_needsResponse;
	sc_core::sc_time delay = now - transfer.m_startTime;
// 	sprintf( transfer.m_respLatRepr, "%d",
// 		 int( delay/m_period ) + i * interval );
// 	sprintf( transfer.m_respAccRepr, "%d", m_master_timing.RpAL );
	m_transfers_pending_data[p_inv->threadid][p_inv->tagid].pop_front();
    }
    flush_queue();
}

// Called with BEGIN_RESP
template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::t_log_new_resp(
    tlm::tlm_generic_payload& txn ) {

    txn_invariant* p_inv;
    acc(txn).get_extension(p_inv);
    assert(p_inv);
    txn_position* p_pos;
    acc(txn).get_extension(p_pos);
    assert(p_pos);

    ocp_txn_track& track = m_burst_tracker[p_inv->threadid][p_inv->tagid];
    //uint32_t starting_count = p_pos->resp_position.count + 1;
    p_pos->resp_position = track.track_phase( txn, tlm::BEGIN_RESP );

    word_count* word_count_info = NULL;
    bool has_word_count= m_ext_support.get_extension(word_count_info, txn);
    uint32_t resp_word_count = has_word_count ?
	word_count_info->value.response_wc : p_inv->burst_length;

    ocpip_legacy::OCPSRespType s_resp;
    switch(txn.get_response_status())
    {
    case tlm::TLM_OK_RESPONSE: s_resp=ocpip_legacy::OCP_SRESP_DVA; break;
    case tlm::TLM_INCOMPLETE_RESPONSE: s_resp=ocpip_legacy::OCP_SRESP_NULL; break;
    default: s_resp=ocpip_legacy::OCP_SRESP_ERR; break;
    }
    if (p_inv->cmd==ocpip_legacy::OCP_MCMD_WRC){
      semaphore* sem;
      m_ext_support.template get_extension<semaphore>(sem, txn);
      if (sem->value==false) s_resp=ocpip_legacy::OCP_SRESP_FAIL;
    }
    sc_core::sc_time now = sc_core::sc_time_stamp();
    int interval = m_slave_timing.RpSndI;

    // Expand TL2 response to fill pending transfers
    for ( uint32_t i=0; i < resp_word_count; ++i ) {
	assert( !m_transfers_pending_resp[p_inv->threadid][p_inv->tagid].empty() );
	Transfer& transfer = *( m_transfers_pending_resp
				[p_inv->threadid][p_inv->tagid].front() );
	assert( !transfer.m_complete );
	transfer.m_resp = s_resp;
	if ( txn.is_read() && txn.get_data_ptr() != NULL ) {
	    transfer.m_data = *((data_type*)( txn.get_data_ptr() + i ));
	}
	transfer.m_complete             = true;
	sc_core::sc_time delay = now - transfer.m_startTime;
	sprintf( transfer.m_respLatRepr, "%d",
		 int( delay/m_period ) + i * interval );
	sprintf( transfer.m_respAccRepr, "%d", m_master_timing.RpAL );
	m_transfers_pending_resp[p_inv->threadid][p_inv->tagid].pop_front();
    }
    flush_queue();
}


template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::print_transfer(
    const OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::Transfer& t )
{
    using namespace ocp_txn_format;
    for( typename std::vector<DisplayEntryBase<Transfer>*>::iterator it =
	     m_entries.begin(); it != m_entries.end(); ++it ) {
	const DisplayEntryBase<Transfer>& entry = **it;
	m_os << entry.format()
	     << entry.display( t ) << " ";
    }
    m_os << '\n';
    m_os << std::flush;
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::flush_queue(bool force) {
    while ( !m_timed_transfers.empty() ) {
	const Transfer& transfer = m_timed_transfers.front();
	if ( !transfer.m_complete && !force ) break;
	print_transfer( transfer );
	m_timed_transfers.pop_front();
    }
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::peq_cb(tlm::tlm_generic_payload& txn, const tlm::tlm_phase& ph){
  mon_delay_info* mon_info;
  acc(txn).get_extension(mon_info);
  assert(mon_info);
  if (mon_info->callNreturn)
    nb_call_callback(mon_info->fwNbw, txn, ph, m_null_time);
  else
    nb_return_callback(mon_info->fwNbw, txn, ph, m_null_time, mon_info->retVal);
  m_monInfoPool.recycle(mon_info);
  acc(txn).clear_extension(mon_delay_info::priv_id);
}


template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::nb_call_callback(
                        bool fwNbw
                       ,tlm::tlm_generic_payload& txn
                       ,const tlm::tlm_phase& phase
                       ,const sc_core::sc_time& time)
{
  if (time!=sc_core::SC_ZERO_TIME){
    mon_delay_info* mon_info=m_monInfoPool.create();
    mon_info->fwNbw=fwNbw;
    mon_info->callNreturn=true;
    acc(txn).set_extension(mon_info);
    tlm::tlm_phase ph=phase;
    m_peq.notify(txn, ph, time);
    return;
  }
  if (fwNbw){ //forward call
    switch (phase){
      case tlm::BEGIN_REQ:
      {
	  t_log_new_req(txn);
	  break;
      }
      case tlm::END_RESP:
	  break;
      default:
        if (phase==BEGIN_DATA){
	    t_log_new_data(txn);
        }
        else if (phase==THREAD_BUSY_CHANGE) {
	    // Not monitoring this
        }
	else if (phase==TL2_TIMING_CHANGE) {
	    if (m_ext_support.template get_extension<tl2_timing>(txn)->value.type==MASTER_TIMING) {
		m_master_timing=m_ext_support.template get_extension<tl2_timing>(txn)->value.master_timing;
	    } else
		std::cerr<<"Monitor warning: TL2 timing update is not for master timing on forward call of link "<<ocp_observer_base::get_name()<<std::endl;
	}
        else {
          std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on forward call of link "<<ocp_observer_base::get_name()<<std::endl;
        }

    }
  }
  else{ //backward call
    switch (phase){
      case tlm::END_REQ:
	  break;
      case tlm::BEGIN_RESP:
	  t_log_new_resp(txn);
	  break;
      default:
        if (phase==END_DATA) {
        }
        else if (phase==THREAD_BUSY_CHANGE){
	    // Not monitoring this
        }
	else if (phase==TL2_TIMING_CHANGE) {
	    if (m_ext_support.template get_extension<tl2_timing>(txn)->value.type==SLAVE_TIMING) {
		m_slave_timing=m_ext_support.template get_extension<tl2_timing>(txn)->value.slave_timing;
	    } else
		std::cerr<<"Monitor warning: TL2 timing update is not for slave timing on backward call of link "<<ocp_observer_base::get_name()<<std::endl;
	}      
        else{
          std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on backward call of link "<<ocp_observer_base::get_name()<<std::endl;
        }
    }
  }
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::nb_return_callback(
                          bool fwNbw
                         ,tlm::tlm_generic_payload& txn
                         ,const tlm::tlm_phase& phase
                         ,const sc_core::sc_time& time
                         ,tlm::tlm_sync_enum retVal)
{
  if (time!=sc_core::SC_ZERO_TIME){
    mon_delay_info* mon_info=m_monInfoPool.create();
    mon_info->fwNbw=fwNbw;
    mon_info->callNreturn=true;
    mon_info->retVal=retVal;
    acc(txn).set_extension(mon_info);
    tlm::tlm_phase ph=phase;
    m_peq.notify(txn, ph, time);
    return;
  }

  if (fwNbw){ //return from fw call    
    switch(retVal){
      case tlm::TLM_ACCEPTED: break;
      case tlm::TLM_UPDATED:
        switch (phase){
          case tlm::END_REQ:
	      break; 
          default:
            if (phase==END_DATA){ //only allowed to be piggy bagged on BEGIN_DATA
            }
            else{
              std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on updated return from forward call of link "
                       <<ocp_observer_base::get_name()<<std::endl;
            }
        }
        break;
      case tlm::TLM_COMPLETED:
        std::cerr<<"Monitor warning: Unexpected TLM_COMPLETED on updated return from forward call of link "
                 <<ocp_observer_base::get_name()<<std::endl;
    }
  }
  else { //return from bw call
    switch(retVal){
      case tlm::TLM_ACCEPTED: break;
      case tlm::TLM_UPDATED: 
        switch (phase){
          case tlm::END_RESP:
	      break;
          default:
            std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on updated return from forward call of link "
                     <<ocp_observer_base::get_name()<<std::endl;
        }
        break;
      case tlm::TLM_COMPLETED:
          std::cerr<<"Monitor warning: Unexpected TLM_COMPLETED on updated return from forward call of link "
                   <<ocp_observer_base::get_name()<<std::endl;
    }
  }
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::b_call_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time){
  std::cerr<<"Monitor warning: B_transport monitoring not supported yet on link "<<ocp_observer_base::get_name()<<std::endl;
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::b_return_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time){
  std::cerr<<"Monitor warning: B_transport monitoring not supported yet on link "<<ocp_observer_base::get_name()<<std::endl;
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
template <uint32_t BUSWIDTH_>
OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::ocp_tl2_txn_monitor(
    OCPIP_VERSION::infr::monitor<BUSWIDTH_, tlm::tlm_base_protocol_types>& mon,
    sc_core::sc_module_name nm, std::ostream& os) :
  sc_core::sc_module(nm)
  , ocp_observer_base(&mon)
  , m_ext_support("mon_ext_support")
  , m_peq(this, &ocp_tl2_txn_monitor::peq_cb, &m_ext_support)
  , m_null_time(sc_core::SC_ZERO_TIME)
  , m_os(os)
  , m_monInfoPool(5)
  , m_byte_width((BUSWIDTH+7)>>3)
  , m_invariantExtPool(5)
  , m_positionExtPool(5)
{
    m_p_trans_access = new ocp_tl2_txn_monitor_trans_access<BUSWIDTH,ADDRWIDTH>();
    m_master_timing.RqSndI = 0;
    m_master_timing.DSndI  = 0;
    m_master_timing.RpAL   = 0;
    m_slave_timing .RqAL   = 0;
    m_slave_timing .DAL    = 0;
    m_slave_timing .RpSndI = 0;
};

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::~ocp_tl2_txn_monitor()
{
    delete m_p_trans_access;
    typename std::vector<ocp_txn_format::DisplayEntryBase<Transfer>*>::iterator it;
    for( it = m_entries.begin(); it != m_entries.end(); ++it ) {
	delete *it;
    }
    m_entries.clear();
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::end_of_elaboration()
{
    const typename OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types>::bind_base_type* init  =ocp_observer_base::get_connected_initiator();
    const typename OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types>::bind_base_type* target=ocp_observer_base::get_connected_target();
    const ocp_socket_base* tmp_i=dynamic_cast<const ocp_socket_base* >(init);
    const ocp_socket_base* tmp_t=dynamic_cast<const ocp_socket_base* >(target);
    if (!tmp_i && !tmp_t){
      std::cerr<<"Error: OCP Monitor "<<ocp_observer_base::get_name()<<" connected on a non-OCP connection."<<std::endl;
      abort();
    }
    ocp_parameters ocp_params_tmp_i, ocp_params_tmp_t;
    if (init){  //other is a ocp base socket
      if (tmp_i){ //it even is an ocp socket
        ocp_params_tmp_i=tmp_i->get_ocp_config();
      }
      else{ //is is a non-ocp ocp base socket
        assert(0 && "Not supported.");
        exit(666);
      }
    }
    else //it is not a ocp base socket, so we assume plain OSCI (compatibility on extension level is there, so we just set up an ocp conf for that)
      ocp_params_tmp_i.init_as_osci_config(BUSWIDTH);

    if (target){  //other is a ocp base socket
      if (tmp_t){ //it even is an ocp socket
        ocp_params_tmp_t=tmp_t->get_ocp_config();
      }
      else{ //is is a non-ocp ocp base socket
        assert(0 && "Not supported.");
        exit(666);
      }
    }
    else //it is not a ocp base socket, so we assume plain OSCI (compatibility on extension level is there, so we just set up an ocp conf for that)
      ocp_params_tmp_t.init_as_osci_config(BUSWIDTH);
    
    ocp_config_support<OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types> >::check_against_ocp_conf(
                             ocp_config_support<OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types> >::OCP_MST
                           , ocp_params_tmp_i
                           , ocp_params_tmp_t
                           , ocp_params_tmp_i);
    m_ocp_params=ocp_params_tmp_i;
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::start_of_simulation()
{
    if ( m_period == sc_core::SC_ZERO_TIME )
	m_period = sc_core::sc_time(1, sc_core::SC_NS);
    m_p_trans_access->m_period = m_period;

    // initialize per-thread/per-tag containers
    int threads = m_ocp_params.threads;
    int tags    = m_ocp_params.tags;
    m_addr_sequence.resize( threads, ocpip_legacy::OcpIp::BurstSequence<addr_type>(
				m_ocp_params.data_wdth,
				m_ocp_params.addr_wdth, 0, 0 ) );
    m_burst_tracker.resize( threads );
    for ( int t=0; t<threads; ++t ) {
	m_burst_tracker[t].resize( tags, ocp_txn_track( &m_ocp_params, false ) );
    }
    m_transfers_pending_data.resize( threads );
    for ( int t=0; t<threads; ++t ) {
	m_transfers_pending_data[t].resize( tags );
    }
    m_transfers_pending_resp.resize( threads );
    for ( int t=0; t<threads; ++t ) {
	m_transfers_pending_resp[t].resize( tags );
    }

    init_display_fields();
    t_log_header();
}

template <uint32_t BUSWIDTH, uint32_t ADDRWIDTH>
void OCPIP_VERSION::ocp_tl2_txn_monitor<BUSWIDTH,ADDRWIDTH>::error(const char* func) const {//std::cout<<"Error "<<func<<" not implemented."<<std::endl; exit(1);
}
