///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

template <class T>
OCPIP_VERSION::ocp_tl1_monitor_signal<T>::ocp_tl1_monitor_signal(const T& initVal): lastTime(sc_core::SC_ZERO_TIME){
  oldVal=initVal;
  newVal=initVal;
}
  
template <class T>
void OCPIP_VERSION::ocp_tl1_monitor_signal<T>::setDelayed(const T& val) const{ //ugly, but inevitable!
  if (sc_core::sc_time_stamp()!=lastTime) { //first update of T in this point of time
    lastTime=sc_core::sc_time_stamp();
    oldVal=newVal;
  }
  newVal=val;
}

template <class T>
bool OCPIP_VERSION::ocp_tl1_monitor_signal<T>::alreadySetDelayed() const{
  return lastTime==sc_core::sc_time_stamp();
}

template <class T>
void OCPIP_VERSION::ocp_tl1_monitor_signal<T>::setDirect(const T& val){
  if (sc_core::sc_time_stamp()==lastTime) //delayed update happened in same point of time as direct update
    oldVal=val;                    //...so we set the old val which is the one to be returned during this point of time
  else
    newVal=val;
}

template <class T>
T& OCPIP_VERSION::ocp_tl1_monitor_signal<T>::get() const{
  //we return a non const ref here to be able to change the current thing
  if (sc_core::sc_time_stamp()==lastTime)
    //T was changed during this point of time, so we return the old one
    return oldVal;
  else
    //it was not changed during this point of time, so newVal is at least 1 time resolution unit old and can be returned
    return newVal;
}
