
void process_command_line(int   argc,
                          char* argv[],
                          string& ocp_params_file_name1,
                          string& ocp_params_file_name2)
{
    // get the ocp parameters file name
    ocp_params_file_name1 = "";
    ocp_params_file_name2 = "";
    if (argc > 2) {
        string file_name1(argv[1]);
        ocp_params_file_name1 = file_name1;
        string file_name2(argv[2]);
        ocp_params_file_name2 = file_name2;
    }
    else {
      cout << "usage ocp_tl1 ocpParam1 ocpParam2" << endl;
      exit(0);
    }

}
void readMapFromFile(const string &myFileName, MapStringType &myParamMap) 
{
    // read pairs of data from the passed file
    string leftside;
    string rightside;
    
    // (1) open the file
    ifstream inputfile(myFileName.c_str());
    assert( inputfile );

    // set the formatting
    inputfile.setf(std::ios::skipws);

    // Now read through all the pairs of values and add them to the passed map
    while ( inputfile ) {
        inputfile >> leftside;
        inputfile >> rightside;
        myParamMap.insert(std::make_pair(leftside,rightside));
    }

    // All done, close up
    inputfile.close();
}

