// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: slave.h,v 1.3 2004/10/04 19:59:39 Anssi Exp $
//
//  Description : OCP - TL2 example Slave
//
// ============================================================================

#ifndef _OCP_TL2_SLAVE_SYNC_H
#define _OCP_TL2_SLAVE_SYNC_H

#define DEBUG_G1

#include <iostream>
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_tl2_slave_port.h"
#include "ocp_tl_param_cl.h"

template <class Td, class Ta>
class Slave : public sc_module {
public:  


  OCP_TL2_SlavePort<Td, Ta> tpP;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc_req();
  void proc_resp();

  // OCP request group
  OCPRequestGrp<Td,Ta> req;

  // OCP response group
  OCPResponseGrp<Td> resp;

  bool is_req;
  bool tmp;
  int last_request;

  sc_event send_response_event;
};

#endif
