///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef OCPIP_VERSION
  #error ocp_tl3_perf_monitor.h may not be included directly. Use #inculde "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif

namespace OCPIP_VERSION{

class ocp_tl3_imc_logger 
  : protected OCPIP_VERSION::infr::ocp_observer_base
{
public:
  
  template <unsigned int BUSWIDTH>
  ocp_tl3_imc_logger( OCPIP_VERSION::infr::monitor<BUSWIDTH, tlm::tlm_base_protocol_types>& mon
                     , const char* filename
                     , unsigned int trace_extensions=0
                     , unsigned int trace_data=0
                     , unsigned int trace_be=0
                     , bool check_release=false);

protected:
  struct release_detector
    : public tlm::tlm_extension<release_detector>
  {
  protected:
    virtual void free(){
      for (std::set<std::ofstream*>::iterator i=m_files.begin(); i!=m_files.end(); i++)
        (**i)<<"+++++ release of transaction "<<m_txn<<" ++++"<<std::endl;
      m_files.clear();
      get_pool()->recycle(this);
    }
    virtual void copy_from(tlm::tlm_extension_base const &){}
    virtual tlm::tlm_extension_base* clone() const {return NULL;}
    
    static ocp_extension_pool<release_detector>* get_pool(){
      static ocp_extension_pool<release_detector>* s_pool=NULL;
      if (!s_pool) s_pool=new ocp_extension_pool<release_detector>(10);
      return s_pool;
    }
    
    std::set<std::ofstream*> m_files; //todo: replace with a faster thing...
    tlm::tlm_generic_payload* m_txn;
  public:
    static release_detector* get_inst(std::ofstream* file, tlm::tlm_generic_payload* txn){
      release_detector* tmp=get_pool()->create();
      tmp->m_files.insert(file);
      tmp->m_txn=txn;
      return tmp;
    }
    
    void add_file(std::ofstream* file){m_files.insert(file);}
  };

  
  
  
  inline void nb_call_callback(bool fwNbw
                       ,tlm::tlm_generic_payload& txn
                       ,const tlm::tlm_phase& phase
                       ,const sc_core::sc_time& time);
                       
  inline void nb_return_callback(bool fwNbw
                         ,tlm::tlm_generic_payload& txn
                         ,const tlm::tlm_phase& phase
                         ,const sc_core::sc_time& time
                         ,tlm::tlm_sync_enum retVal);

  inline void b_call_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time);
  
  inline void b_return_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time);

  inline void decode_txn(tlm::tlm_generic_payload& txn);
  
  std::ofstream m_file;
  unsigned int m_trace_extensions, m_trace_data, m_trace_be;
  bool m_check_release;

};
}

#include __MACRO_STRINGYFY__(../mon/src/OCPIP_VERSION/ocp_tl3_imc_logger.tpp)
