// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Joe Chou, Sonics Inc., joechou@sonicsinc.com
//         Date : 07/18/2003
//
//  Description : Transaction Level - parameter class.
//                The parameter class is a mean to report
//                parameters like Master priorities or Slave addresses
//                to other modules (e.g. the Bus). Its basic usage model
//                is to write values to this class in the elaboration
//                phase and read these values from the parameter class
//                at the beginning of the simulation.
//
// ============================================================================

// This file contains the definition of the classes:
// template <class TdataCl> class ParamCl

#ifndef _TL_Param_CL
#define _TL_Param_CL

#ifdef USEANTLR
#include "ModelConfigCl.h"
#endif

template <class TdataCl> class ParamCl
{
public:

  typedef typename TdataCl::AddrType Ta;

  // Constructor
  ParamCl()
  : MasterID(-1)
  , Priority(-1)
  , SlaveID(-1)
  , StartAddress(0)
  , EndAddress(0)
  { // default values
    CmdAccept  = true;
    RespAccept = true;
    DataAccept = true;
  }

  //  Master parameter
  int MasterID; // Non-negative integer number < TL2_MAX_MASTERS
  int Priority; // Non-negative integer number (higher value = higher priority)

  // Slave parameter
  int SlaveID;     // Non-negative integer number < TL2_MAX_SLAVES
  Ta StartAddress; // Start address of the memory
  Ta EndAddress;   // End address of the memory

  // OCP parameters
  bool CmdAccept;  // true = SCmdAccept is always high
  bool RespAccept; // true = MRespAccept is always high
  bool DataAccept; // true = SDataAccept is always high

#ifdef USEANTLR
  //
  MAPType Map;

  // If parameter loading is used

  void setOCPConfiguration(string ocp_name, ModelConfigCl& MCDatabase) {
      MCDatabase.getOCPConfiguration(ocp_name,Map);
  };

  void dumpConfiguration(void) {
      cout << endl << "Map:" << endl;
      MAPType::iterator map_it;
      for (map_it = Map.begin(); map_it != Map.end(); ++map_it) {
          cout << "map[" << map_it->first << "] = " << map_it->second
               << endl;
      }
  }
#endif
};

#endif // _TL_Param_CL

