// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                (modified by Joe Chou, Sonics Inc., joechou@sonicsinc.com)
//         Date : 03/25/2003
//
//  Description : Global defines and function declarations
//
// ============================================================================

// File contains two parts: 
//   - Part 1 is generic (for all Layers) and therefore should be included
//     only ones (in a mixed Layer simulation)
//   - Part 2 is Layer specific                      

//------------------------------------
// Layer independent global definitions

#ifndef _OCP_TL_GLOBALS_H
#define _OCP_TL_GLOBALS_H

#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include <new>
#include "systemc.h"

#include "ocp_tl_param_cl.h"  // Parameter class, use only one per system
                              // If necessary merge all parameters into one
                              // class

const sc_time_unit TL_TIME_SCALE = SC_NS;       // clock period
const double TL_TIME_SCALE_SEC   = 0.000000001;

// Allowed Slave response values
const int TL_SRESP_OK    = 1;
const int TL_SRESP_ERROR = 3;


// Activation flag for timing output information
// #define DEBUG_M  // Master timing
// #define DEBUG_M1  // more Master timing
// #define DEBUG_B  // Bus timing
#define DEBUG_B1  // Bus setup
#define DEBUG_S  // Slave timing
// #define DEBUG_S1 // Slave timing (response delay)
// #define DEBUG_C  // Channel timing
// #define TRACE_C    // Channel timing output into file
#define DEBUG_G1   // Output of request/response duration comming from
                   // Master, Bus, Slave modules

#endif // _TL_GLOBALS_H

//------------------------------------
// Layer-2 specific global definitions

#ifndef _OCP_TL2_GLOBALS_H
#define _OCP_TL2_GLOBALS_H

// maximum number of items sent in one burst
const int TL2_MAX_BURST_LENGTH = 60;

// Data class over which the modules are templatized
// The data class itself is templatized: DataCl<DataType, AddressType>
// DataType can be any e.g. int, sc_int<64>, sc_bigint<1024>,sc_bv<1024>,
// sc_lv<256>, ...
// AddressType must be either a native integer C++ type, or
// sc_int<>, sc_uint<>. E.g. int, long, sc_uint<64>, ...
#define OCP_TL2_TEMPL_DATA_CL OCP_TL2_DataCl< int, int >

#endif // _OCP_TL2_GLOBALS_H
