// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stphane Guntz, PROSILOG, guntz@prosilog.com
//         Date : 06/2003
//
//  Description : 
//  testbench for tl1 slave adapter example
//
// ============================================================================

#include "systemc.h"
#include "tl_channel.h"
#include "ocp_tl2_master.h"
#include "ocp_tl1_slave_sync.h"
#include "ocp_tl1_tl2_slave_adapter.h"


int sc_main(int argc, char* argv[])
{

  bool SynchronChannel= true;
  
  sc_clock clk("clock", 1, SC_NS, 0.5, 0, SC_NS, true);

  //TL1 and TL2 channels instantiation 
  TL_Channel<TL1_TEMPL_DATA_CL > channel0("channel0", SynchronChannel);
  TL_Channel< OCP_TL2_TEMPL_DATA_CL > channel1("channel1",SynchronChannel,true);

  //TL2 master and TL1 slave instantiation
  OCP_TL2_Master<OCP_TL2_TEMPL_DATA_CL> master2("master2", 1, 1,true, false, 0, 0, 0, 0);
  OCP_TL1_Slave_Sync<TL1_TEMPL_DATA_CL>  slave2("slave2", 2, 0, 0xff);

  //adapter instantiation
  //maximum burst length=16, adapter depth= 2, no response to a write request from the slave
  OCP_TL1_TL2_Slave_Adapter<TL1_TEMPL_DATA_CL, OCP_TL2_TEMPL_DATA_CL > slave_adapter("slave_adapter", 16, 2, false);

  //binding
  master2.MasterP(channel1);

  slave_adapter.SlaveP(channel1);
  slave_adapter.MasterP(channel0);
  slave_adapter.clk(clk);

  slave2.SlaveP(channel0);
  slave2.clk(clk);

  sc_start(50, SC_NS);

  return 0;
}
