// 
//  Copyright 2005 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP-IP TLM kit
//       Author : Herve Alexanian
//         $Id: 
//
//  Description : TL3 STL-driven example system 
//
// ============================================================================

#include "generic_stl_master_tl3.h"
#include "generic_mem_slave_tl3.h"
#include "command_line.h"

SC_MODULE( Top ) {
    sc_core::sc_clock clk;
    // Submodules
    ocpip_example::generic_mem_slave_tl3 <32> sl3;
    ocpip_example::generic_stl_master_tl3<32> ms3;

    Top( sc_core::sc_module_name name, int argc, char* argv[] ) :
	sc_core::sc_module( name )
	, sl3( "sl3" )
	, ms3( "ms3" )
{
	// OCP parameters from command line
	map_string_type  ocpParamMap;
	std::string ocpParamFileName = "ocpParams"; // default
	process_command_line(argc,argv,ocpParamFileName);
	if ( ! ocpParamFileName.empty() ) {
	    readMapFromFile(ocpParamFileName, ocpParamMap);
	}

	// Set OCP configuration
	ocpip::ocp_parameters params;
	params=create_ocp_configuration_from_map("sl3", ocpParamMap);
	sl3.m_socket.set_ocp_config(params);
	ms3.m_socket.set_ocp_config(params);
	ms3.set_period( sc_core::sc_time( 10, sc_core::SC_NS ) );
	ms3.m_socket(sl3.m_socket);
    }
};


int sc_main(int argc, char* argv[]) {
    scv_random::set_global_seed(22);
    Top top( "top", argc, argv );
    // Simulator
    sc_core::sc_start(200, sc_core::SC_NS);   
    return(0);
}

