///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : James Aldis, Texas Instruments
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  Common stuff shared by all modules of the TL1 timing
//                 example
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TIMING_COMMON_H__
#define __TIMING_COMMON_H__

#include "ocpip.h"
#include "instance_specific_extensions.h"
#include "../../unit_test/tlm/multi_sockets/include/extensionPool.h"
#include "legacy_config_map.h"

template <typename T>
T my_max(T a, T b){return (a>b)? a : b;}

struct local_thread_ID : public tlm_utils::instance_specific_extension<local_thread_ID>{
  unsigned int local_id;
};

#include <fstream>

//#define NO_REGRESSION

#ifdef NO_REGRESSION

long int get_address_random(const std::string&){ long int tmp=random(); long int lowbits=tmp & 0x3; tmp-=lowbits; return tmp;}
double unit_rand(const std::string&) { return (double(random() & 0xFFFFFF)/double(0xFFFFFF));}
#else

long int get_address_random(const std::string& user){

  static std::ifstream* mA=NULL;
  static std::ifstream* mB=NULL;
  static std::ifstream* mC=NULL;
  static std::ifstream* mD=NULL;

  long int tmp;

  if (user=="mA") {assert(!mA->eof()); (*mA)>>tmp;}
  else
  if (user=="mB") {assert(!mB->eof()); (*mB)>>tmp;}
  else
  if (user=="mC") {assert(!mC->eof()); (*mC)>>tmp;}
  else
  if (user=="mD") {assert(!mD->eof()); (*mD)>>tmp;}
  else
  if (user=="finalize"){
    std::cout<<"Closing address random files"<<std::endl;
    mA->close();
    mB->close();
    mC->close();
    mD->close();
    delete mA;
    delete mB;
    delete mC;
    delete mD;
  }
  else
  if (user=="init"){
    std::cout<<"Opening address random files"<<std::endl;
    mA=new std::ifstream();
    mB=new std::ifstream();
    mC=new std::ifstream();
    mD=new std::ifstream();
    mA->open((std::string("mA")+std::string("_addresses")).c_str(), std::ios::in);
    mB->open((std::string("mB")+std::string("_addresses")).c_str(), std::ios::in);
    mC->open((std::string("mC")+std::string("_addresses")).c_str(), std::ios::in);
    mD->open((std::string("mD")+std::string("_addresses")).c_str(), std::ios::in);
    assert(!mA->fail());
    assert(!mB->fail());
    assert(!mC->fail());
    assert(!mD->fail());
  }
  else
    assert(0);
  return tmp;
}

double unit_rand(const std::string& user) {
  static std::ifstream* mA=NULL;
  static std::ifstream* mB=NULL;
  static std::ifstream* mC=NULL;
  static std::ifstream* mD=NULL;
  static std::ifstream* sA=NULL;
  static std::ifstream* sB=NULL;
  static std::ifstream* sC=NULL;
  static std::ifstream* sD=NULL;
  double tmp;

  if (user=="mA") {assert(!mA->eof()); (*mA)>>tmp;}
  else
  if (user=="mB") {assert(!mB->eof()); (*mB)>>tmp;}
  else
  if (user=="mC") {assert(!mC->eof()); (*mC)>>tmp;}
  else
  if (user=="mD") {assert(!mD->eof()); (*mD)>>tmp;}
  else
  if (user=="sA") {assert(!sA->eof()); (*sA)>>tmp;}
  else
  if (user=="sB") {assert(!sB->eof()); (*sB)>>tmp;}
  else
  if (user=="sC") {assert(!sC->eof()); (*sC)>>tmp;}
  else
  if (user=="sD") {assert(!sD->eof()); (*sD)>>tmp;}
  else
  if (user=="finalize"){
    std::cout<<"Closing unit random files"<<std::endl;
    mA->close();
    mB->close();
    mC->close();
    mD->close();
    sA->close();
    sB->close();
    sC->close();
    sD->close();
    delete mA;
    delete mB;
    delete mC;
    delete mD;
    delete sA;
    delete sB;
    delete sC;
    delete sD;
  }
  else
  if (user=="init"){
    std::cout<<"Opening unit random files"<<std::endl;
    mA=new std::ifstream();
    mB=new std::ifstream();
    mC=new std::ifstream();
    mD=new std::ifstream();
    sA=new std::ifstream();
    sB=new std::ifstream();
    sC=new std::ifstream();
    sD=new std::ifstream();
    mA->open((std::string("mA")+std::string("_unit")).c_str(), std::ios::in);
    mB->open((std::string("mB")+std::string("_unit")).c_str(), std::ios::in);
    mC->open((std::string("mC")+std::string("_unit")).c_str(), std::ios::in);
    mD->open((std::string("mD")+std::string("_unit")).c_str(), std::ios::in);
    sA->open((std::string("sA")+std::string("_unit")).c_str(), std::ios::in);
    sB->open((std::string("sB")+std::string("_unit")).c_str(), std::ios::in);
    sC->open((std::string("sC")+std::string("_unit")).c_str(), std::ios::in);
    sD->open((std::string("sD")+std::string("_unit")).c_str(), std::ios::in);
    assert(!mA->fail());
    assert(!mB->fail());
    assert(!mC->fail());
    assert(!mD->fail());
    assert(!sA->fail());
    assert(!sB->fail());
    assert(!sC->fail());
    assert(!sD->fail());

  }
  else
    assert(0);
  return tmp;
}

#endif
map_string_type get_config_map(unsigned int num_threads, unsigned int data_width){
  map_string_type config_map;

  config_map["broadcast_enable"]="i:0";
  config_map["burst_aligned"]="i:0";
  config_map["burstseq_dflt1_enable"]="i:0";
  config_map["burstseq_dflt2_enable"]="i:0";
  config_map["burstseq_incr_enable"]="i:0";
  config_map["burstseq_strm_enable"]="i:0";
  config_map["burstseq_unkn_enable"]="i:0";
  config_map["burstseq_wrap_enable"]="i:0";
  config_map["burstseq_xor_enable"]="i:0";
  config_map["burstseq_blck_enable"]="i:0";
  config_map["endian"]="i:1";
  config_map["force_aligned"]="i:0";
  config_map["mthreadbusy_exact"]="i:1";
  config_map["rdlwrc_enable"]="i:0";
  config_map["read_enable"]="i:1";
  config_map["readex_enable"]="i:0";
  config_map["sdatathreadbusy_exact"]="i:0";
  config_map["sthreadbusy_exact"]="i:1";
  config_map["write_enable"]="i:0";
  config_map["writenonpost_enable"]="i:0";
  config_map["datahandshake"]="i:0";
  config_map["reqdata_together"]="i:0";
  config_map["writeresp_enable"]="i:0";
  config_map["addr"]="i:1";
  config_map["addr_wdth"]="i:32";
  config_map["addrspace"]="i:0";
  config_map["addrspace_wdth"]="i:1";
  config_map["atomiclength"]="i:0";
  config_map["atomiclength_wdth"]="i:1";
  config_map["burstlength"]="i:0";
  config_map["burstlength_wdth"]="i:0";
  config_map["blockheight"]="i:0";
  config_map["blockheight_wdth"]="i:1";
  config_map["blockstride"]="i:0";
  config_map["blockstride_wdth"]="i:1";
  config_map["burstprecise"]="i:0";
  config_map["burstseq"]="i:0";
  config_map["burstsinglereq"]="i:0";
  config_map["byteen"]="i:1";
  config_map["cmdaccept"]="i:0";
  config_map["connid"]="i:0";
  config_map["connid_wdth"]="i:1";
  config_map["dataaccept"]="i:0";
  config_map["datalast"]="i:0";
  config_map["datarowlast"]="i:0";
  std::stringstream s;
  s<<"i:"<<data_width;
  config_map["data_wdth"]=s.str();
  config_map["mdata"]="i:0";
  config_map["mdatabyteen"]="i:0";
  config_map["mdatainfo"]="i:0";
  config_map["mdatainfo_wdth"]="i:1";
  config_map["mdatainfobyte_wdth"]="i:1";
  config_map["sdatathreadbusy"]="i:0";
  config_map["mthreadbusy"]="i:1";
  config_map["reqinfo"]="i:0";
  config_map["reqinfo_wdth"]="i:1";
  config_map["reqlast"]="i:0";
  config_map["reqrowlast"]="i:0";
  config_map["resp"]="i:1";
  config_map["respaccept"]="i:0";
  config_map["respinfo"]="i:0";
  config_map["respinfo_wdth"]="i:1";
  config_map["resplast"]="i:0";
  config_map["resprowlast"]="i:0";
  config_map["sdata"]="i:1";
  config_map["sdatainfo"]="i:0";
  config_map["sdatainfo_wdth"]="i:1";
  config_map["sdatainfobyte_wdth"]="i:1";
  config_map["sthreadbusy"]="i:1";
  s.clear();
  s.str("");
  s<<"i:"<<num_threads;
  config_map["threads"]=s.str();
  config_map["tags"]="i:1";
  config_map["taginorder"]="i:0";
  config_map["control"]="i:0";
  config_map["controlbusy"]="i:0";
  config_map["control_wdth"]="i:1";
  config_map["controlwr"]="i:0";
  config_map["interrupt"]="i:0";
  config_map["merror"]="i:0";
  config_map["mflag"]="i:0";
  config_map["mflag_wdth"]="i:1";
  config_map["mreset"]="i:0";
  config_map["serror"]="i:0";
  config_map["sflag"]="i:0";
  config_map["sflag_wdth"]="i:1";
  config_map["sreset"]="i:0";
  config_map["status"]="i:0";
  config_map["statusbusy"]="i:0";
  config_map["statusrd"]="i:0";
  config_map["status_wdth"]="i:1";
  config_map["sthreadbusy_pipelined"]="i:0";
  config_map["mthreadbusy_pipelined"]="i:0";
  config_map["sdatathreadbusy_pipelined"]="i:0";
  return config_map;
}

#endif
