///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//
//          $Id:
//
//  Description :  Simple helper functions that parse the command line arguments
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef __LEGACY_CONFIG_MAP_H__
#define __LEGACY_CONFIG_MAP_H__


typedef std::map<std::string, std::string> map_string_type;

// The parameter myParamValue is set only if the parameter is found in the 
// configuration map and if it is of type 'i' for integer.
inline bool 
getBoolOCPConfigValue(
  const std::string& myPrefix, 
  const std::string& myParamName, 
  bool &myParamValue, 
  map_string_type& Map, 
  std::string my_name) 
{
    map_string_type::iterator pos = Map.find(myPrefix+myParamName);
    if (pos == Map.end())
    {
        // This parameter not found
        return false;
    } 

    // Set the parameter
    std::string myValue = pos->second;
    std::istringstream valueStream(myValue);
    char type;
    valueStream >> type;
    if (type != 'i')
    {
        // We were expecting an integer type for this command.
#ifndef NDEBUG 
        std::cout << "WARNING: " << my_name << ": Type 'i' expected for boolean parameter "
            << myPrefix+myParamName
            << " but got '" << myValue << "' instead." << std::endl;
#endif
        return false;
    }
    // passed all tests. Set the value.
    // first get rid of the colon
    char shouldBeColon;
    valueStream >> shouldBeColon;
    bool tmp;
    valueStream >> tmp;
    myParamValue=tmp;
    return true;
}  

// The parameter myParamValue is set only if the parameter is found in the 
// configuration map and if it is of type 'i' for integer.
inline bool 
getIntOCPConfigValue(
  const std::string& myPrefix, 
  const std::string& myParamName, 
  int &myParamValue, 
  map_string_type& Map, 
  std::string my_name)
{
    map_string_type::iterator pos = Map.find(myPrefix+myParamName);
    if (pos == Map.end())
    {
        // This parameter not found
        return false;
    } 

    // Set the parameter
    std::string myValue = pos->second;
    std::istringstream valueStream(myValue);
    char type;
    valueStream >> type;
    if (type != 'i')
    {
        // We were expecting an integer type for this command.
#ifndef NDEBUG
        std::cout << "WARNING: " << my_name << ": Type 'i' expected for parameter "
            << myPrefix+myParamName
            << " but got '" << myValue << "' instead." << std::endl;
#endif
        return false;
    }
    // passed all tests. Set the value.
    // first get rid of the colon
    char shouldBeColon;
    valueStream >> shouldBeColon;
    int tmp;
    valueStream >> tmp;
    myParamValue=tmp;
    return true;
}  

// The parameter myParamValue is set only if the parameter is found in the 
// configuration map and if it is of type 's' for std::string.
inline bool 
getStringOCPConfigValue(
  const std::string& myPrefix, 
  const std::string& myParamName, 
  std::string& myParamValue, 
  map_string_type& Map, 
  std::string my_name) 
{
    map_string_type::iterator pos = Map.find(myPrefix+myParamName);
    if (pos == Map.end())
    {
        // This parameter not found
        return false;
    } 

    // Set the parameter
    std::string myValue = pos->second;
    std::istringstream valueStream(myValue);
    char type;
    valueStream >> type;
    if (type != 's')
    {
        // We were expecting a std::string type for this command.
#ifndef NDEBUG
        std::cout << "WARNING: " << my_name << ": Type 's' expected for std::string parameter "
            << myPrefix+myParamName
            << " but got '" << myValue << "' instead." << std::endl;
#endif
        return false;
    }
    // passed all tests. Set the value.
    // first get rid of the colon
    char shouldBeColon;
    valueStream >> shouldBeColon;
    std::string tmp;
    valueStream >> tmp;
    myParamValue=tmp;
    return true;
}  

inline ocpip::ocp_parameters create_ocp_configuration_from_map(std::string name, map_string_type& passedMap)
{
    // ocp_name is passed by value as it will be changed below.

    // Set my Map to the passed map.
    //Map = passedMap;

    ocpip::ocp_parameters params;

    // Set my name to the passed name.
    params.name = name;

    // NOTE: keyPrefix is no longer needed, but kept here in case it changes
    //       again in the future.
    // std::string keyPrefix = ocp_name;
    std::string keyPrefix = "";

    getBoolOCPConfigValue(keyPrefix, "broadcast_enable", params.broadcast_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burst_aligned", params.burst_aligned,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_dflt1_enable", params.burstseq_dflt1_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_dflt2_enable", params.burstseq_dflt2_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_incr_enable", params.burstseq_incr_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_strm_enable", params.burstseq_strm_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_unkn_enable", params.burstseq_unkn_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_wrap_enable", params.burstseq_wrap_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_xor_enable", params.burstseq_xor_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq_blck_enable", params.burstseq_blck_enable, passedMap, name);
    getIntOCPConfigValue(keyPrefix, "endian", params.endian,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "force_aligned", params.force_aligned,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "mthreadbusy_exact", params.mthreadbusy_exact,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "rdlwrc_enable", params.rdlwrc_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "read_enable", params.read_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "readex_enable", params.readex_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sdatathreadbusy_exact", params.sdatathreadbusy_exact,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sthreadbusy_exact", params.sthreadbusy_exact,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "write_enable", params.write_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "writenonpost_enable", params.writenonpost_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "datahandshake", params.datahandshake,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "reqdata_together", params.reqdata_together,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "writeresp_enable", params.writeresp_enable,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "addr", params.addr,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "addr_wdth", params.addr_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "addrspace", params.addrspace,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "addrspace_wdth", params.addrspace_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "atomiclength", params.atomiclength,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "atomiclength_wdth", params.atomiclength_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstlength", params.burstlength,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "burstlength_wdth", params.burstlength_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "blockheight", params.blockheight,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "blockheight_wdth", params.blockheight_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "blockstride", params.blockstride,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "blockstride_wdth", params.blockstride_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstprecise", params.burstprecise,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstseq", params.burstseq,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "burstsinglereq", params.burstsinglereq,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "byteen", params.byteen,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "cmdaccept", params.cmdaccept,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "connid", params.connid,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "connid_wdth", params.connid_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "dataaccept", params.dataaccept,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "datalast", params.datalast,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "datarowlast", params.datarowlast,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "data_wdth", params.data_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "mdata", params.mdata,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "mdatabyteen", params.mdatabyteen,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "mdatainfo", params.mdatainfo,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "mdatainfo_wdth", params.mdatainfo_wdth,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "mdatainfobyte_wdth", params.mdatainfobyte_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sdatathreadbusy", params.sdatathreadbusy,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "mthreadbusy", params.mthreadbusy,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "reqinfo", params.reqinfo,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "reqinfo_wdth", params.reqinfo_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "reqlast", params.reqlast,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "reqrowlast", params.reqrowlast,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "resp", params.resp,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "respaccept", params.respaccept,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "respinfo", params.respinfo,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "respinfo_wdth", params.respinfo_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "resplast", params.resplast,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "resprowlast", params.resprowlast,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sdata", params.sdata,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sdatainfo", params.sdatainfo,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "sdatainfo_wdth", params.sdatainfo_wdth,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "sdatainfobyte_wdth", params.sdatainfobyte_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sthreadbusy", params.sthreadbusy,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "threads", params.threads,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "tags", params.tags,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "taginorder", params.taginorder,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "control", params.control,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "controlbusy", params.controlbusy,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "control_wdth", params.control_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "controlwr", params.controlwr,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "interrupt", params.interrupt,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "merror", params.merror,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "mflag", params.mflag,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "mflag_wdth", params.mflag_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "mreset", params.mreset,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "serror", params.serror,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sflag", params.sflag,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "sflag_wdth", params.sflag_wdth,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "sreset", params.sreset,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "status", params.status,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "statusbusy", params.statusbusy,passedMap,name);
    getBoolOCPConfigValue(keyPrefix, "statusrd", params.statusrd,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "status_wdth", params.status_wdth,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "tag_interleave_size", params.tag_interleave_size,passedMap,name);
    getIntOCPConfigValue(keyPrefix, "enableclk", params.enableclk,passedMap,name);  
 
    getBoolOCPConfigValue(keyPrefix, "sthreadbusy_pipelined", params.sthreadbusy_pipelined, passedMap, name);
    getBoolOCPConfigValue(keyPrefix, "sdatathreadbusy_pipelined", params.sdatathreadbusy_pipelined, passedMap, name);
    getBoolOCPConfigValue(keyPrefix, "mthreadbusy_pipelined", params.mthreadbusy_pipelined, passedMap, name);
    
    return params;
}

#endif
