// 
//  Copyright 2006 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Anssi Haverinen, Nokia
//                Herve Alexandrian, Sonics
//         $Id: main.cpp,v 1.1 2006/01/30 22:12:12 halexan Exp $
//
//  Description:  TL0-TL1 adapter demo
//                
// ============================================================================





// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel.h"

// Include user-defined headers
#include "channel_types.h"

// Include submodules

#include "CPUMaster.h"
#include "Slave.h"

int sc_main(int argc, char* argv[]) {

  CPUMaster ms1("ms1");
  Slave sl1("sl1");

  sc_clock tp_Clk("TestClock", 10, SC_NS,0.5);

  sc_signal< sc_bv< 3 > > tp_MCmd;
  sc_signal<sc_bv<A1Size> > tp_MAddr;
  sc_signal<sc_bv<D1Size> > tp_MData;
  sc_signal<sc_bv<D1Size/8> > tp_MByteEn;
  sc_signal<bool> tp_MRespAccept;
  sc_signal<bool> tp_SCmdAccept;
  sc_signal<sc_bv<2> > tp_SResp;
  sc_signal<sc_bv<D1Size> > tp_SData;

  ms1.MCmd( tp_MCmd );
  ms1.MAddr( tp_MAddr );
  ms1.MData ( tp_MData );
  ms1.MByteEn( tp_MByteEn );
  ms1.MRespAccept( tp_MRespAccept );
  ms1.SCmdAccept( tp_SCmdAccept );
  ms1.SResp( tp_SResp );
  ms1.SData( tp_SData );
  ms1.Clk( tp_Clk );

  sl1.MCmd( tp_MCmd );
  sl1.MAddr( tp_MAddr );
  sl1.MData ( tp_MData );
  sl1.MByteEn( tp_MByteEn );
  sl1.MRespAccept( tp_MRespAccept );
  sl1.SCmdAccept( tp_SCmdAccept );
  sl1.SResp( tp_SResp );
  sl1.SData( tp_SData );
  sl1.Clk( tp_Clk );


  sc_start(5, SC_MS);
  
  return(0);
}
